#!/usr/bin/perl -w

$|=1;
print "Content-Type: text/html\n\n";

#link to this Perl script on your server
$proglink = "/cgi-bin/praytim.cgi";
#link to text database(ptdata.txt) on your server
$prayTimeInfo = "../txt/ptdata.txt";
#$prayTimeInfo = "c:/wwwroot/txt/ptdata.txt";

#INSTRUCTION
#Perl source code "Praytim.cgi" Copyright  2006 Samir Alicehajic
#and it was Free for use in the name of Allah Subhanahu Wa Ta'ala
#If you need a quick help email me at: samir@agnatemoslem.net
#1. GRANT OF LICENSE TO USE FREEWARE
#Praying times calculation Freeware software is FREE for use without any kind of charge.
#2. GRANT OF LICENSE TO DUPLICATE AND DISTRIBUTE FREEWARE
#All copies distributed by Recipient must be "exact copies" of an original Freeware 
#supplied by Samir Alicehajic; that there be no charge or request for donations
#for any Freeware distributed by Recipient.

#Original C source code Copyright  2002 Fayez Alhargan.
#King Abdulaziz City for Science and Technology
#Computer and Electronics Research Institute Riyadh, Saudi Arabia
#alhargan@kacst.edu.sa, Tel:4813770, Fax:4813764

$mySiteName = "Get PrayTimes C & Perl source code";
$mySiteLink = "http://www.angatemoslem.net/data/perl/ptsource.zip";
$myTD = "<td align=center width=80>";
$pi = 3.1415926535897932;
$DToR = ($pi / 180.0);
$RToH = (12 / $pi);
$EarthRadius = 6378.14;
$HStartYear = 1420;
$HEndYear = 1450;
@MonthMap=(19410,19396,19337,19093,13613,13741,15210,18132,19913,19858,19110,18774,12974,13677,13162,15189,19114,14669,13469,14685,12986,13749,17834,15701,19098,14638,12910,13661,15066,18132,18085);
@gmonth=(31,31,28,31,30,31,30,31,31,30,31,30,31,31);
@smonth=(31,30,30,30,30,30,29,31,31,31,31,31,31,30);
@dowl = ("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");
@GregDays = ("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
@GregMonths = ("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
@HijriMonths = ("MuHarram", "Safar", "Raby` al-awal", "Raby` al-THaany", "Jumaada al-awal", "Jumaada al-THaany", "Rajab", "SHa`baan", "RamaDHaan", "SHawwal", "Thw al-Qi`dah", "Thw al-Hijjah");
@DaysArabic = ("", "", "", "", "", "", "");
@HijriMonthsArabic = ("   ", "", "", " ", " ", " ", " ", "", "", "", "", " ", " ");

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
	($name, $value) = split(/=/, $pair);

	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	$value =~ s/<([^>]|\n)*>//g;
	$value =~ s/<//g;
	$value =~ s/>//g;
	$FORM{$name} = $value;
}
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$mon += 1;
$year+=1900;

if (length($FORM{'town'}) == 0) { $FORM{'town'} = " "; }
if (length($FORM{'day'}) == 0) { $FORM{'day'} = 0; }
if (length($FORM{'nday'}) == 0) { $FORM{'nday'} = 0; }
if ((length($FORM{'year'}) == 0) || ($FORM{'year'} == 0)) {
	$FORM{'year'} = $year;
}
if ((length($FORM{'month'}) == 0) || ($FORM{'month'} == 0) || ($FORM{'month'} > 12)) {
	$FORM{'month'} = $mon;
}
if (length($FORM{'tzone'}) == 0) { $FORM{'tzone'} = 1; }

if ($FORM{'day'} >= @gmonth[$FORM{'month'}]) {
	$FORM{'day'} = @gmonth[$FORM{'month'}];
}
elsif ($FORM{'day'} <= 0) { $FORM{'day'} = 1; }

if (($FORM{'nday'} <= 0) || ($FORM{'nday'}+$FORM{'day'} > @gmonth[$FORM{'month'}])) {
	$FORM{'nday'} = @gmonth[$FORM{'month'}] - $FORM{'day'} + 1;
}

print "<html><head>\n";
print "<title>Praying times</title>\n";
print "<style>\n";
print "TD { font-family: Verdana; font-size: 10pt; font-weight: regular ; }\n";
print "</style></head>\n";
print "<body bgcolor=\"#CFCFCF\" text=\"#000000\" link=\"#0000FF\" vlink=\"#0000CC\" alink=\"#0000CC\" topmargin=\"0\" leftmargin=\"0\">\n";
print "<center><table border=\"1\" cellpadding=\"4\" cellspacing=\"4\" width=\"640\" bordercolordark=\"#E0E0E0\" bordercolorlight=\"#A0A0A0\">\n";
print "<tr><td align=center colspan=\"8\"><b>Notes:</b> For GMT look at your computor under \"Control panel/Date and Time/Time zone\"</td></tr>\n";
print "<tr><td align=center colspan=\"2\"><form action=\"$proglink\" method=\"POST\">\n";
print "<input type=\"hidden\" name=\"lt\" value=\"$FORM{'lt'}\">\n";
print "<input type=\"hidden\" name=\"lg\" value=\"$FORM{'lg'}\">\n";
print "Year<br><input type=\"text\" size=\"8\" name=\"year\" value=\"$FORM{'year'}\"></td>\n";
print "<td align=center colspan=\"2\">Month<br><input type=\"text\" size=\"8\" name=\"month\" value=\"$FORM{'month'}\"></td>\n";
print "<td align=center colspan=\"2\">From date<br><input type=\"text\" size=\"8\" name=\"day\" value=\"$FORM{'day'}\"></td>\n";
print "<td align=center colspan=\"2\">Number of days<br><input type=\"text\" size=\"8\" name=\"nday\" value=\"$FORM{'nday'}\"></td></tr>\n";
print "<tr><td align=center colspan=\"4\"><select name=\"town\" size=\"1\">\n";
$bFound = 0;
if (open(FILE, "$prayTimeInfo")) {
	@infos=(<FILE>);
	close(FILE);
	$nInfo = @infos;
	for ($t=0; $t<$nInfo; $t++) {
		@infos[$t] =~ tr/\r\n//d;
		@infos[$t] =~ tr/\n//d;
		@cur = split(/;/, @infos[$t]);
		if (@cur[0] eq $FORM{'town'}) { 
			print "<option selected>@cur[0]</option>\n";
			$FORM{'lt'} = @cur[1];
			$FORM{'lg'} = @cur[2];
			$bFound = 1;
		}
		else { print "<option>@cur[0]</option>\n"; }
	}
}
print "</select>&nbsp;<input type=\"text\" size=\"2\" name=\"tzone\" value=\"$FORM{'tzone'}\">&nbsp;GMT+DayLight\n</td><td align=center colspan=\"4\"><input type=\"submit\" name=\"submit\" value=\"Submit\"></from></td></tr>";
if ($bFound == 0) { 
   	print("<tr>$myTD&nbsp;</td>$myTD&nbsp;</td>$myTD&nbsp;</td>$myTD&nbsp;</td>$myTD&nbsp;</td>$myTD&nbsp;</td>$myTD&nbsp;</td>$myTD&nbsp;</td></tr>\n");
	print "<tr><td align=center colspan=\"8\">To show praying times select a \"Town\" on the left and click on the \"Submit\" button</td></tr>";
    print("<tr><td colspan=4 align=center><font size=1><a href=\"$mySiteLink\">$mySiteName</a></font></td><td colspan=4 align=center width=\"320\"><font size=1><a href=\"http://www.angatemoslem.net\">Created by: Samir Alicehajic</a></font></td></tr>\n");
    print("</table></center><br></body></html>\n");
	exit;
}
else { 
	PrayTime($FORM{'town'}, $FORM{'tzone'}, $FORM{'lt'}, $FORM{'lg'}, $FORM{'year'}, $FORM{'month'}, $FORM{'day'}, $FORM{'nday'}); 
}

sub PrayTime
{
	my($ptown, $Zonh, $latud, $longtud, $yg, $mg, $dg, $nd) = @_;
   	$day=0; 
   	$hour=0;
   	$min=0; 
   	$sec=0; 
   	$bSec=0;
   	$yg0=0; 
   	$mg0=0; 
   	$dg0=0; 
   	$yh1=0; 
   	$mh1=0; 
   	$dh1=0; 
   	$dayweek=0; 
   	$i=0;
   	@lst=(0,0,0,0,0,0,0,0,0,0,0,0,0,0);
   	@param=(0,0,0,0,0,0,0,0,0,0,0,0);

 	for($i = 0; $i < 12; $i++) { @lst[$i] = 0; }
  	$dg0 = $dg - 1;
   	$mg0 = $mg;
   	$yg0 = $yg;

   	print("<tr><td align=center colspan=\"8\"><b>Praying times for: $ptown, @GregMonths[$mg-1]  $yg<br>Geographical latitude: $FORM{'lt'}&nbsp;&nbsp;&nbsp;&nbsp;Geographical longitude: $FORM{'lg'}</b></td></tr>\n");
   	print("<tr>$myTD&nbsp;</td>$myTD&nbsp;</td>$myTD<b>Fajr</b></td>$myTD<b>SHorwwQ</b></td>$myTD<b>DHuhr</b></td>$myTD<b>`ASr</b></td>$myTD<b>MaGHrib</b></td>$myTD<b>`ISHaa'</b></td></tr>\n");
   	print("<tr>$myTD<b>Date</b></td>$myTD<b>Day</b></td>$myTD<b>Dawn</b></td>$myTD<b>Sunrise</b></td>$myTD<b>Noon</b></td>$myTD<b>Afternoon</b></td>$myTD<b>Sunset</b></td>$myTD<b>Evening</b></td></tr>\n");
   	for($day = 1; $day <= $nd; $day++) {
   		$yh1=0;
   		$mh1=0;
   		$dh1=0;
   		$dg0++;
	   	GDateAjust(\$yg0, \$mg0, \$dg0);
	  	G2HA(int $yg0, int $mg0, int $dg0, \$yh1, \$mh1, \$dh1, \$dayweek);
	   	@param[0] = 0.016388;
	   	@param[1] = $longtud * $DToR;
	   	@param[2] = $latud * $DToR;
	   	@param[3] = 300.0;
	   	@param[4] = 300.0;
	   	@param[5] = $Zonh;
	   	@param[6] = 19 * $DToR;
	   	@param[7] = 0;
	   	@param[8] = 1;
	   	@param[9] = 45 * $DToR;
	   	@param[10] = 1.5;
	   	@param[11] = 4.2 * $DToR;
		OmAlQrahr(int $yg0, int $mg0, int $dg0, \@lst, @param);
	   	print("<tr>$myTD<b>$dg0</b></td>$myTD<b>@dowl[$dayweek]</b></td>");
      	for($i = 1; $i <= 6; $i++) {
			$hour = int @lst[$i];
		   	$min = int (60.0 * (@lst[$i] - $hour));
		   	if ($bSec) {
				$sec = 3600.0 * (@lst[$i] - $hour - ($min / 60.0));
		   		if($sec > 30) { $min = $min + 1; }
		   	}
		   	if($min == 60)  { $hour++; $min = 0;}
		   	if($min < 0) { $min = -($min); }
		   	if ($bSec) {
				if($sec == 60)  { $min++; $sec = 0; }
		   		if($sec < 0) { $sec = -($sec); }
		   	}
			print("$myTD$hour:$min ");
		   	if ($bSec) { print(":$sec"); }
		   	print "</td>";
      	}
      	print("</tr>\n");
	}
    print("<tr><td colspan=4 align=center><font size=1><a href=\"$mySiteLink\">$mySiteName</a></font></td><td colspan=4 align=center><font size=1><a href=\"http://www.angatemoslem.net\">Created by: Samir Alicehajic</a></font></td></tr></table></center><br></body></html>\n");
    print("</table></center><br></body></html>\n");
}


sub BH2GA
{
	my($yh, $mh, $yg, $mg, $dg, $dayweek) = @_;
	$ycc = $$yg;
	$mcc = $$mg;
	$dcc = $$dg;
	
  	
  	if($mh < 1) { $mh = 12; }
  	if($mh > 12) { $mh = 1; }
  	if($yh < HStartYear) { $yh = HStartYear; }
  	if($yh > HEndYear) { $yh = HEndYear; }

   	$GJD = HCalendarToJDA(int $yh, int $mh, 1);
   	JDToGCalendar($GJD, \$ycc, \$mcc, \$dcc);
   	$JD = $GJD;
   	$$dayweek = ($JD + 1) % 7;
	$$yg = $ycc;
	$$mg = $mcc;
	$$dg = $dcc;
}
sub HCalendarToJDA
{
	my ($yh, $mh, $dh) = @_;

   	$JD = HCalendarToJD(int $yh, 1, 1);
   	$Dy = int (@MonthMap[$yh - $HStartYear] / 4096);
   	$GJD = $JD - 3 + $Dy;
   	$b = @MonthMap[$yh - $HStartYear];
   	$b = int ($b - $Dy * 4096);
   	for($m = 1; $m < $mh; $m++) {
   		$flag = $b % 2;
    	if($flag) { $Dy = 30; }
    	else { $Dy = 29; }
    	$GJD = $GJD + $Dy;
    	$b = ($b - $flag) / 2;
   	}
   	$GJD = $GJD + $dh - 1;

   	return $GJD;
}
sub HMonthLength
{
	my ($yh, $mh) = @_;

  	if(($yh < $HStartYear) || ($yh > $HEndYear)) { $Dy = 0; }
 	else {
   		$Dy = int (@MonthMap[$yh - $HStartYear] / 4096);
   		$b = @MonthMap[$yh - $HStartYear];
   		$b = int ($b - $Dy * 4096);
    	for($m = 1; $m <= $mh; $m++) {
      		$flag = $b % 2;
      		if($flag) { $Dy = 30; }
         	else { $Dy = 29; }
      		$b = int (($b - $flag) / 2);
     	}
	}
   	return $Dy;
}
sub DayinYear {
	my($yh, $mh, $dh) = @_;
	$DL = 0;

  	if(($yh < $HStartYear) || ($yh > $HEndYear)) { $DL = 0; }
 	else {
   		$Dy = @MonthMap[$yh - $HStartYear] / 4096;
	   	$b = @MonthMap[$yh - $HStartYear];
   		$b = $b - $Dy * 4096;
	   	$DL = 0;
    	for($m = 1; $m <= $mh; $m++) {
	      	$flag = $b % 2;
    	  	if($flag) { $Dy = 30; }
        	else { $Dy = 29; }
	      	$b = ($b - $flag) / 2;
    	  	$DL = $DL + $Dy;
     	}
	   	$DL = $DL + $dh;
	}
   	return $DL;
}
sub HYearLength
{
	my($yh) = @_;
	$YL = 0;
  	if (($yh < $HStartYear) || ($yh > $HEndYear)) { $YL = 0; }
 	else {
   		$Dy = @MonthMap[$yh - $HStartYear] / 4096;
	   	$b = @MonthMap[$yh - $HStartYear];
   		$b = $b - $Dy * 4096;
	   	$flag = $b % 2;
   		if($flag) { $YL = 30; }
	    else { $YL = 29; }
    	for($m = 2; $m <= 12; $m++) {
	      	$flag = $b % 2;
    	  	if($flag) { $Dy = 30; }
        	else { $Dy = 29; }
      		$b = ($b - $flag) / 2;
      		$YL = $YL + $Dy;
     	}
	}
   return $YL;
}
sub G2HA
{
	my($yg, $mg, $dg, $yh, $mh, $dh, $dayweek) = @_;

	$yh1=0;
	$mh1=0;
   	$dh1=0;
   	$yh2=0;
   	$mh2=0;
   	$yg1=0;
   	$mg1=0;
   	$dg1=0;
   	$df=0;
   	$dw2=0;
  	$J=0;
  	$GJD=0;
   	$HJD=0;

   	$GJD = GCalendarToJD(int $yg, int $mg, $dg + 0.5);
   	JDToHCalendar($GJD, \$yh1, \$mh1, \$dh1);

	#print "------- $GJD, $yh1, $mh1, $dh1\n";

   	$HJD = HCalendarToJDA(int $yh1, int $mh1, int $dh1);

   	$df = int ($GJD - $HJD);
   	$dh1 = int ($dh1 + $df);
   	while($dh1 > 30) {
   		$dh1 = int ($dh1 - HMonthLength(int $yh1, int $mh1));
     	$mh1++;
     	if($mh1 > 12) { $yh1++; $mh1 = 1;}
   	}
   	if($dh1 == 30) {
   		$mh2 = $mh1 + 1;
    	$yh2 = $yh1;
    	if($mh2 > 12) { $mh2 = 1; $yh2++; }
    	BH2GA($yh2, $mh2, \$yg1, \$mg1, \$dg1, \$dw2);
    	if($dg == $dg1) { $yh1 = $yh2; $mh1 = $mh2; $dh1 = 1; }
	}
   	$J = (GCalendarToJD(int $yg, int $mg, int $dg) + 2);

   	$$dayweek = int ($J % 7);
   	$$yh = int $yh1;
   	$$mh = int $mh1;
   	$$dh = int $dh1;
}
sub H2GA
{
	my($yh, $mh, $dh, $yg, $mg, $dg, $dayweek) = @_;
   	$yh1=0;
   	$mh1=0;
   	$yg1=0;
   	$mg1=0;
   	$dg1=0;
   	$dw1=0;

   	if($$dh > 30) { $$dh = 1; ($$mh)++; }
   	if($$dh < 1)  { $$dh = 1; ($$mh)--; }
   	if($$mh > 12) { $$mh = 1; ($$yh)++; }
   	if($$mh < 1)  { $$mh = 12; ($$yh)--; }

   	BH2GA(\$$yh, \$$mh, $yg, $mg, $dg, $dayweek);
   	$$dg = $$dg + $$dh - 1;
   	GDateAjust($yg, $mg, $dg);
   	$$dayweek = $$dayweek + $$dh - 1;
   	$$dayweek = $$dayweek % 7;

	if($$dh == 30) {
   		$mh1 = $$mh+1;
    	$yh1 = $$yh;
    	if($mh1 > 12) { $mh1 = $mh1 - 12; $yh1++; }
      	BH2GA($yh1, $mh1, \$yg1, \$mg1, \$dg1, \$dw1);
    	if($$dg == $dg1) { $$yh = $yh1; $$mh = $mh1; $$dh = 1; }
	}
}
sub JDToGCalendar
{
	my($JD, $yy, $mm, $dd) = @_;

  	$Z = floorSam($JD + 0.5);
  	$F = ($JD + 0.5) - $Z;
  	$alpha = int (($Z - 1867216.25) / 36524.25);
  	$A = $Z + 1 + $alpha - $alpha / 4;
  	$B = $A + 1524;
  	$C = int (($B - 122.1) / 365.25);
  	$D = (365.25 * $C);
  	$E = int (($B - $D) / 30.6001);
  	$$dd = int ($B - $D - floorSam(30.6001 * $E) + $F);
  	if ($E < 14) { $$mm = $E - 1; }
  	else { $$mm = $E - 13; }
  	if ($$mm > 2) { $$yy = $C - 4716; }
  	else { $$yy = $C - 4715; }
  	$F = $F * 24.0;

  	return $F;
}
sub GCalendarToJD
{
	my ($yy, $mm, $dd) = @_;

  	if ($mm > 2) { $y = $yy; $m = $mm; }
  	else { $y = $yy - 1; $m = $mm + 12; }
  	$A = int ($y / 100);
  	$B = int (2 - $A + $A / 4);

  	$T1 = ip(365.25 * ($y + 4716));
  	$T2 = ip(30.6001 * ($m + 1));
  	$Tr = $T1 + $T2 + $dd + $B - 1524.5;

  	return $Tr;
}
sub GLeapYear
{
	my ($year) = @_;
	$T = 0;

   	if($year % 4 == 0) { $T = 1; }
   	if($year % 100 == 0) {
   		$T = 0;
	 	if($year % 400 == 0) { $T = 1; }
   	}
	return $T;
}
sub GDateAjust
{
	my ($yg, $mg, $dg) = @_;
	$dys=0;

   	if($$mg < 1) {
   		$$mg = 12 + $$mg;
	   	$$yg = $$yg - 1;
   	}
	if($$dg < 1) {
   		$$mg = $$mg - 1;
	   	$$dg = @gmonth[$$mg] + $$dg;
	   	if($$mg == 2) { $$dg = $$dg + GLeapYear($$yg); }
	   	if($$mg < 1) {
      		$$mg = 12 + $$mg;
	     	$$yg = $$yg - 1;
      	}
   	}
   	if($$mg > 12) {
   		$$mg = $$mg - 12;
	   	$$yg = $$yg + 1;
   	}
   	if($$mg == 2) { $dys = @gmonth[$$mg] + GLeapYear($$yg); }
   	else { $dys = @gmonth[$$mg]; }
   	if($$dg > $dys) {
   		$$dg = $$dg - $dys;
      	$$mg = $$mg + 1;
      	if($$mg == 2) {
      		$dys = @gmonth[$$mg] + GLeapYear($$yg);
	      	if($$dg > $dys) {
				$$dg = $$dg - $dys;
				$$mg = $$mg + 1;
         	}
      	}
      	if($$mg > 12) {
      		$$mg = $$mg - 12;
	     	$$yg = $$yg + 1;
      	}
   	}
}
sub DayWeek
{
	my ($JulianD) = @_;

	return (int (($JulianD + 1) % 7));
}
sub HCalendarToJD
{
	my($yh, $mh, $dh) = @_;

 	$md = int (($mh - 1.0) * 29.530589);
 	$yd = int (($yh - 1.0) * 354.367068 + $md + $dh - 1.0);
 	$yd = int ($yd + 1948439.0);

 	return $yd;
}
sub JDToHCalendar
{
	my($JD, $yh, $mh, $dh) = @_;


 	$yd = $JD - 1948439.0;
 	$md = mod($yd, 354.367068);
 	$$dh = int (mod($md + 0.5, 29.530589) + 1);
 	$$mh = int (($md / 29.530589) + 1);
 	$yd = $yd - $md;
 	$$yh = int ($yd / 354.367068 + 1);
 	if($$dh > 30) { $$dh = $$dh - 30; $$mh+=1; }
 	if($$mh > 12) { $$mh = $$mh - 12; $$yh+=1; }
}
sub JDToHACalendar
{
	my ($JD, $yh, $mh, $dh, $dayweek) = @_;
	$yh1=0;
   	$mh1=0;
   	$dh1=0;

	JDToHCalendar($JD, \$yh1, \$mh1, \$dh1);
   	$HJD = HCalendarToJDA(int $yh1, int $mh1, int $dh1);
   	$df = $JD + 0.5 - $HJD;
   	$dh1 = $dh1 + $df;
   	while($dh1 > 30) {
   		$dh1 = $dh1 - HMonthLength(int $yh1, int $mh1);
     	$mh1++;
     	if($mh1 > 12) { $yh1++; $mh1=1;}
   	}
   	if($dh1 == 30 && HMonthLength(int $yh1, int $mh1) < 30) { $dh1 = 1; $mh1++; }
   	if($mh1 > 12) { $mh1 = 1; $yh1++; }

	$J = $JD + 2;
   	$$dayweek = $J % 7;
   	$$yh = $yh1;
   	$$mh = $mh1;
   	$$dh = $dh1;
}
sub ip
{
	my($x) = @_;

   	@b = split(/\./, $x);
	if (length(@b[0]) > 0) { return @b[0]; }
	else { return 0; }
}
sub mod
{
	my($x, $y) = @_;

  	$d = $x / $y;
  	$r = int $d;
  	if ($r < 0) { $r--; }
  	$d = $x - $y * $r;
  	$r = int $d;
  	
 	return $r;
}
sub IsValid
{
	my($yh, $mh, $dh) = @_;

  	$valid = 1;
  	if(($yh < $HStartYear) || ($yh > $HEndYear)) { $valid = 0; }
  	if(($mh < 1) || ($mh > 12) || ($dh < 1)) { $valid = 0; }
   	elsif($dh > HMonthLength(int $yh, int $mh)) { $valid = 0; }

  	return $valid;
}
sub atanxy
{
	my($x, $y) = @_;

   	if($x == 0) { $argm = 0.5 * $pi; }
   	else { $argm = atan($y / $x); }
	if(($x > 0) && ($y < 0)) { $argm = 2.0 * $pi + $argm; }
   	if($x < 0) { $argm = $pi + $argm; }
	
	return $argm;
}
sub EclipToEquator
{
	my($lmdr, $betar, $alph, $dltr) = @_;
	$eps = 23.441884;
 	$sdlt=0;
   	$epsr=0;
 	$x=0;
   	$y=0;
 	$rad = 0.017453292;

 	$epsr = $eps * $rad;
 	$sdlt = sin($betar) * cos($epsr) + cos($betar) * sin($epsr) * sin($lmdr);
 	$$dltr = asin($sdlt);
 	$y = sin($lmdr) * cos($epsr) - tan($betar) * sin($epsr);
 	$x = cos($lmdr);
 	$$alph = atanxy($x, $y);
}
sub RoutinR2
{
	my($M, $e) = @_;

	$dt = 1;
   	$dE=0;
  	$Ec = $M;
  	while(fabsSam($dt) > 1e-9) {
   		$dt = $Ec - $e * sin($Ec) - $M;
	    $dE = $dt / (1 - $e * cos($Ec));
    	$Ec = $Ec - $dE;
	}
 	return $Ec;
}
sub SunParamr
{
	my($yg, $mg, $dg, $ObsLon, $ObsLat, $TimeZone, $Rise, $Transit, $Setting, $RA, $Decl, $RiseSetFlags) = @_;
	$UT=0; $ET=0; $y=0; $L=0; $e=0; $M=0;
  	$T=0; $JD=0; $Ec=0;
  	$tnv=0; $v=0; $tht=0;
  	$K=0; $angl=0; $T1=0; $T2=0; $H=0; $cH=0;

  	$$RiseSetFlags = 0;

  	$JD = GCalendarToJD(int $yg, int $mg, int $dg);
   	$T = ($JD + ($TimeZone / 24.0) - 2451545.0) / 36525.0;

  	$L = 279.6966778 + 36000.76892 * $T + 0.0003025 * $T * $T;
  	while($L > 360) { $L = $L - 360; }
  	while($L < 0) { $L = $L + 360; }
  	$L = $L * ($pi / 180.0);

  	$M = 358.47583 + 35999.04975 * $T - 0.00015 * $T * $T - 0.0000033 * $T * $T * $T;
  	while($M > 360) { $M = $M - 360; }
  	while($M < 0) { $M = $M + 360; }
  	$M = $M * ($pi / 180.0);

  	$e = 0.01675104 - 0.0000418 * $T - 0.000000126 * $T * $T;
  	$Ec = 23.452294 - 0.0130125 * $T - 0.00000164 * $T * $T + 0.000000503 * $T * $T * $T;
  	$Ec = $Ec * $pi / 180.0;

  	$y = tan(0.5 * $Ec);
  	$y = $y * $y;
  	$ET = $y * sin(2 * $L) - 2 * $e * sin($M) + 4 * $e * $y * sin($M) * cos(2 * $L) - 0.5 * $y * $y * sin(4 * $L) - 5 * 0.25 * $e * $e * sin(2 * $M);
  	$UT = $ET * 180.0 / (15.0 * $pi);

  	$Ec = RoutinR2($M, $e);
  	$tnv = sqrt((1 + $e) / (1 - $e)) * tan(0.5 * $Ec);
  	$v = 2.0 * atan($tnv);
  	$tht = $L + $v - $M;

  	EclipToEquator($tht, 0, \$$RA, \$$Decl);

  	$K = 12 - $UT - $TimeZone + $ObsLon * 12.0 / $pi;
  	$$Transit = $K;
   	$angl = (-0.833333) * $DToR;
   	$T1 = (sin($angl) - sin($$Decl) * sin($ObsLat));
   	$T2 = (cos($$Decl) * cos($ObsLat));
   	$cH = $T1 / $T2;
   	if($cH > 1) { $$RiseSetFlags = 16; $cH = 1; }
   	$H = acos($cH);
   	$H = $H * 12.0 / $pi;
   	$$Rise = $K - $H;
   	$$Setting = $K + $H;

   	return $JD;
}


sub OmAlQrahr
{
	my($yg, $mg, $dg, $lst, @param) = @_;

	$flag = 1;
   	$flagrs=0;
   	$problm = 0;
   	$RA=0; $Decl=0; $Rise=0; $Transit=0; $Setting=0; $SINd=0; $COSd=0; $act=0;
   	$H=0; $angl=0; $K=0; $cH=0; $X=0; $MaxLat=0;
   	$H0=0; $Night=0; $IshRt=0; $FajrRt=0; $HightCorWest=0; $HightCorEast=0; $IshFix=0;
   	$FajrFix=0;

  	SunParamr(int $yg, int $mg, int $dg, -(@param[1]), @param[2], -(@param[5]), \$Rise, \$Transit, \$Setting, \$RA, \$Decl, \$flagrs);
  	$SINd = sin($Decl) * sin(@param[2]);
  	$COSd = cos($Decl) * cos(@param[2]);
   	$K = $Transit;
   	$HightCorWest = 0;
   	$HightCorEast = 0;
   	if(($flagrs == 0) && (fabsSam(@param[2]) < 0.79) && ((@param[4] != 0) || (@param[3] != 0))) {
   		$angl = -0.83333 * $DToR;
    	$cH = (sin($angl) - $SINd) / ($COSd);
    	$H0 = acos($cH);
    	$X = $EarthRadius * 1000.0;
    	$angl = -0.83333 * $DToR + (0.5 * $pi - asin($X / ($X + @param[3])));
    	$cH = (sin($angl) - $SINd) / ($COSd);
    	$HightCorWest = acos($cH);
    	$HightCorWest = ($H0 - $HightCorWest) * ($RToH);
    	$angl = -0.83333 * $DToR + (0.5 * $pi - asin($X / ($X + @param[4])));
    	$cH = (sin($angl) - $SINd) / ($COSd);
    	$HightCorEast = acos($cH);
    	$HightCorEast = ($H0 - $HightCorEast) * ($RToH);
	}
  	if(!(($flagrs == 0) && (fabsSam($Setting - $Rise) > 1) && (fabsSam($Setting - $Rise) < 23))) {
	   	$problm = 1;
     	if(@param[2] < 0) { $MaxLat = -fabsSam(@param[9]); }
    	else {$MaxLat = fabsSam(@param[9]); }
     	SunParamr(int $yg, int $mg, int $dg, -(@param[1]), $MaxLat, -(@param[5]), \$Rise, \$Transit, \$Setting, \$RA, \$Decl, \$flagrs);
     	$K = $Transit;
     	$SINd = sin($Decl) * sin($MaxLat);
     	$COSd = cos($Decl) * cos($MaxLat);
   	}
   	if($K < 0) { $K = $K + 24; }
   	@$lst[2] = $Rise - $HightCorEast;
   	@$lst[3] = $K + @param[0];
   	@$lst[5] = $Setting + $HightCorWest + @param[0];
   	if($problm) { $act = @param[8] + tan(fabsSam($Decl - $MaxLat)); }
   	else { $act = @param[8] + tan(fabsSam($Decl - @param[2])); }
   	$angl = atan(1.0 / $act);
   	$cH = (sin($angl) - $SINd) / ($COSd);
   	if(fabsSam($cH) > 1.0) { $H = 3.5; $flag = 0; }
  	else { $H = acos($cH); $H = $H * $RToH; }
   	@$lst[4] = $K + $H + @param[0];

   	$angl = -(@param[6]);
  	$cH = (sin($angl) - $SINd) / ($COSd);
  	if(fabsSam(@param[2]) < 0.83776) {
   		$H = acos($cH);
     	$H = $H * $RToH;
     	@$lst[1] = $K - ($H + $HightCorEast) + @param[0];
     	@$lst[7] = @$lst[1];
  	}
 	else {
   		if(@param[2] < 0) { GetRatior($yg, 12, 21, @param, \$IshFix, \$FajrFix); }
	 	else { GetRatior($yg, 6, 21, @param, \$IshFix, \$FajrFix); }

   		if(fabsSam($cH) > (0.45 + 1.3369 * @param[6])) {
      		$Night = 24 - ($Setting - $Rise);
      		@$lst[1] = $Rise - $Night * $FajrFix;
   		}
  		else {
     		$H = acos($cH);
     		$H = $H * $RToH;
     		@$lst[1] = $K - ($H + $HightCorEast) + @param[0];
      	}
   		@$lst[7] = @$lst[1];
   		if(fabsSam($cH) > 1) {
     		GetRatior($yg, $mg, $dg, @param, \$IshRt, \$FajrRt);
     		$Night = 24 - ($Setting - $Rise);
     		@$lst[7] = $Rise - $Night * $FajrRt;
   		}
  		else {
     		$H = acos($cH);
     		$H = $H * $RToH;
     		@$lst[7] = $K - ($H + $HightCorEast) + @param[0];
      	}
  	}
   	if(@param[7] != 0) {
   		$angl = -(@param[7]);
      	$cH = (sin($angl) - $SINd) / ($COSd);
      	if(fabsSam(@param[2]) < 0.83776) {
			$H = acos($cH);
			$H = $H * $RToH;
			@$lst[6] = $K + ($H + $HightCorWest + @param[0]);
			@$lst[8] = @$lst[6];
   		}
    	else {
     		if(fabsSam($cH) > (0.45 + 1.3369 * @param[6])) {
	  			$Night = 24 - ($Setting - $Rise);
	  			@$lst[6] = $Setting + $Night * $IshFix;
			}
       		else {
				$H = acos($cH);
				$H = $H * $RToH;
				@$lst[6] = $K + ($H + $HightCorWest + @param[0]);
       		}
	      	if(fabsSam($cH) > 1.0) {
	  			GetRatior($yg, $mg, $dg, @param, \$IshRt, \$FajrRt);
	  			$Night = 24 - ($Setting - $Rise);
	  			@$lst[8] = $Setting + $Night * $IshRt;
			}
       		else {
				$H = acos($cH);
				$H = $H * $RToH;
				@$lst[8] = $K + ($H + $HightCorWest + @param[0]);
       		}
   		}
   	}
   	else {
   		@$lst[6] = @$lst[5] + @param[10];
      	@$lst[8] = @$lst[6];
   	}
   	$angl = @param[11];
  	$cH = (sin($angl) - $SINd) / ($COSd);
  	if(((fabsSam(@param[2]) < 1.134) || ($flagrs == 0)) && (fabsSam($cH) <= 1)) {
   		$H = acos($cH);
     	$H = $H * $RToH;
     	@$lst[9] = $K - ($H + $HightCorEast) + @param[0];
  	}
 	else { @$lst[9] = @$lst[2] + 0.25; }

	return $flag;
}
sub GetRatior
{
	my($yg, $mg, $dg, @param, $IshRt, $FajrRt) = @_;
	$flagrs=0;
   	$RA=0; $Decl=0; $Rise=0; $Transit=0; $Setting=0; $SINd=0; $COSd=0;
   	$H=0; $angl=0; $cH=0; $MaxLat=0; $FjrRf=0; $IshRf=0; $Night=0;

   	if(@param[2] < 0) { $MaxLat = -(fabsSam(@param[9])); }
   	else { $MaxLat = fabsSam(@param[9]); }
   	SunParamr(int $yg, int $mg, int $dg, -(@param[1]), $MaxLat, -(@param[5]), \$Rise, \$Transit, \$Setting, \$RA, \$Decl, \$flagrs);
   	$SINd = sin($Decl) * sin($MaxLat);
   	$COSd = cos($Decl) * cos($MaxLat);
   	$Night = 24 - ($Setting - $Rise);
   	$angl = -(@param[6]);
   	$cH = (sin($angl) - $SINd) / ($COSd);
   	$H = acos($cH);
   	$H = $H * $RToH;
   	$FjrRf = $Transit - $H - @param[0];
   	if(@param[7] != 0) {
   		$angl = -(@param[7]);
      	$cH = (sin($angl) - $SINd) / ($COSd);
      	$H = acos($cH);
      	$H = $H * $RToH;
      	$IshRf = $Transit + $H + @param[0];
   	}
   	else { $IshRf = $Setting + @param[10]; }

   	$$IshRt = ($IshRf - $Setting) / $Night;
   	$$FajrRt = ($Rise - $FjrRf) / $Night;
}
sub fabsSam
{
	my ($ch) = @_;
	
	$ch = abs($ch);
	return $ch;	
}	
sub floorSam
{
	my($x) = @_;

   	@b = split(/\./, $x);
  	return @b[0];
}

#sub deg_to_rad { ($_[0]/180) * $pi }
#sub rad_to_deg { ($_[0]/$pi) * 180 }
sub asin 
{ 
	my ($x) = @_;
	return atan2($x, sqrt(1 - $x * $x));
}
sub acos 
{ 
	my ($x) = @_;
	return atan2(sqrt(1 - $x * $x), $x);
}
sub tan 
{ 
	my ($x) = @_;
	return (sin($x) / cos($x)); 
}
sub atan 
{ 
	my ($x) = @_;
	return atan2($x,1);
}

exit;