/* ISLAMIC PRAYERS *****************************************\
 *                                                         *
 *  2004-2006 By Samir Alicehajic (samir@yildun.com)       *
 *  http://www.yildun.com                                  *
 *  Copyright (C) 2004-2006 Samir Alicehajic               *
 *  THIS SOURCE CODE IS FREE FOR USE IN THE NAME OF        *
 *	 ALLAH SUBHANAHU WA TA'ALA                              *
 *  This SOURCE CODE is distributed in the hope that it    *
 *  will be useful, but WITHOUT ANY WARRANTY; without even *
 *  the implied warranty of MERCHANTABILITY or             *
 *  FITNESS FOR A PARTICULAR PURPOSE.                      *
 *  However you can use part of this source code in your   *
 *  own software                                           *
 *                                                         *
\***********************************************************/

#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <stdio.h>
#include <math.h>
#include "praytimes.h"
#include "resource.h"

#define NUM_TABS 5
#define ABOUT_LINES 9

extern void BrziSamLine(HDC hdc, int x1, int y1, int x2, int y2, COLORREF cref1, int wid);
extern void BrziSam(HWND hwnd, HDC hdc, int x1, int y1, int x2, int y2, COLORREF cref1, COLORREF cref2, int wid);
extern HFONT CreateSamFont(INT bold, INT w, INT h, BYTE Charset, char *strFaceName);
extern LPBYTE SamGetRegPath(void);

extern int PrayingTimesCalculation(char *filesave, double Zonh, double longtud, double latud, int yg, int mg, int dg, int nd);
extern int G2HA(int yg, int mg, int dg, int *yh, int *mh, int *dh, int *dayweek);
extern void GDateAjust(int *yg, int *mg, int *dg);
extern int HMonthLength(int yh, int mh);
extern double HCalendarToJDA(int yh, int mh, int dh);
extern int DayWeek(long JulianD);

HINSTANCE hInst;
HWND hwndMain, hwndCurTab;
DWORD dwVersion, dwVer;
BOOL bWindowsNT;
int curTab=0;
HFONT samFont[2];
COLORREF cr_tool, cr_gray, cr_light, cr_black, cr_white, cr_red, cr_green;
HBRUSH hBrushGray, hBrushTool, hBrushLight, hBrushBlue, hBrushGreen;

//Praying times dialog
WORD FirstDay[14];
double latitude = 45.49;
double longitude = 15.59;
int TimeZone = 1;
int cyear, cmonth, cday;
char workdir[MAX_PATH], szAppName[20], strVarious[512];
char strFilePrayTime[MAX_PATH], strFilePrayData[MAX_PATH];
char strNameTown[MAX_PATH]= {"Zagreb"};

//Calendar dialog
extern short gmonth[14];
extern char GregMonths[12][50];
extern char HijriMonths[12][50];

//Author dialog
HIMAGELIST hImageAboutList;
char aboutLine[ABOUT_LINES][192]={
{"THE KORAN - [ Freeware ] - Beautiful animated The Qur'an - holy muslim book on 13-21 languages."},
{"ISLAM - [ Freeware ] - All you need to know about Islam religion, Hadiths, Qur'an, Praying"},
{"ACCESS IMAGE - [ Shareware ] -  proffesional, cheap and easy graphics editor and GIF constructor"},
{"DISK ORDER - [ Shareware ] - two panels file browser/managment tools, CD-RW recorder, FTP and much more"},
{"REC_CD - [ Shareware ] -  simple, copy your files and directories onto CD-R/W"},
{"YILDUN SCANNER - [ Freeware ] -  easy graphics editor, image viewer, screen capture and much more"},
{"LOGAN'S FIGHT - [ Freeware ] - Action adventure game - defend Earth againest aliens, excellent game"},
{"FIELD FILLER - [ Freeware ] - Clipboard tool software. Save, copy and paste easily"},
{"GLOBAL EDIT - [ Shareware ] - Versaitle Text editor software with multilevel undo"},
};
BOOL InitAboutList(HWND hdlg);
BOOL AddAboutListItem(HWND hdlg, int image, int n, char *text);


int HijriYear, HijriMonth, HijriDay, HijriDayWeek;
int GregYear, GregMonth, GregDay, GregDayWeek;
BOOL bHijri = TRUE;
void PaintOneMonth(HWND hwnd, HDC hdc, int month);
void SetNameMonths(HWND hwnd);
void UpdateHijri(HWND hdlg, WORD jr);
void GregFirstDayWeek(SYSTEMTIME sg);


LRESULT CALLBACK PrayingTimesProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK TextProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK CalendarProc(HWND, UINT, WPARAM, LPARAM);
extern LRESULT CALLBACK AnimationProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AuthorProc(HWND, UINT, WPARAM, LPARAM);

void SamSysColors(void);
void SetTabChildPos(HWND hwnd);
long filesize(char *source);

void savcfg(BOOL ft);


LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

LRESULT MsgInit(HWND, UINT, WPARAM, LPARAM);
LRESULT MsgCommand(HWND, UINT, WPARAM, LPARAM);
LRESULT MsgNotify(HWND, UINT, WPARAM, LPARAM);
LRESULT MsgClose(HWND, UINT, WPARAM, LPARAM);

LRESULT CmdExit(HWND, WORD, WORD, HWND);

VOID WINAPI ChangeTab(HWND hwnd);
DLGTEMPLATE * WINAPI DoLockDlgRes(LPCSTR lpszResName);

MSD rgmsd[] =
{
	{WM_COMMAND,    	  MsgCommand},
   {WM_INITDIALOG, 	  MsgInit},
   {WM_NOTIFY,     	  MsgNotify},
   {WM_CLOSE,          MsgClose},
};

MSDI msdiMain =
{
    sizeof(rgmsd) / sizeof(MSD),
    rgmsd,
    edwpWindow
};
CMD rgcmd[] =
{
	{IDCANCEL,            CmdExit},
};

CMDI cmdiMain =
{
    sizeof(rgcmd) / sizeof(CMD),
    rgcmd,
    edwpWindow
};

#pragma argsused
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
   WNDCLASS wcm;
   LPBYTE lpPath;

   if ((lpPath = SamGetRegPath()) != NULL) strcpy(workdir, (char*)lpPath);
   else GetCurrentDirectory(MAX_PATH, workdir);
   ZeroMemory(szAppName, sizeof(szAppName));
   LoadString(hInstance, IDS_APPNAME, szAppName, sizeof(szAppName));
   hInst = hInstance;
   ZeroMemory(strFilePrayTime, sizeof(strFilePrayTime));
   ZeroMemory(strFilePrayData, sizeof(strFilePrayData));
   wsprintf(strFilePrayTime, "%s\\PrayingTimes.txt", workdir);
   wsprintf(strFilePrayData, "%s\\ptdata.txt", workdir);

   InitCommonControls();
   wcm.style         = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
   wcm.lpfnWndProc   = (WNDPROC)WndProc;
   wcm.cbClsExtra    = 0;
   wcm.cbWndExtra    = DLGWINDOWEXTRA;
   wcm.hInstance     = hInst = hInstance;
   wcm.hIcon         = LoadIcon(hInstance, "IDI_APPICON");
   wcm.hCursor       = LoadCursor(NULL, IDC_ARROW);
   wcm.hbrBackground = (HBRUSH)(COLOR_WINDOW);
   wcm.lpszMenuName  = (HMENU)NULL;
   wcm.lpszClassName = szAppName;

	if (!RegisterClass(&wcm)) {
   	if (!RegisterClass((LPWNDCLASS)&wcm.style)) return FALSE;
	}
   dwVersion = GetVersion();
	DialogBox(hInst, "IDD_PT", NULL, (DLGPROC)WndProc);

   return 0;
}
LRESULT DispMessage(LPMSDI lpmsdi, HWND hwnd, UINT uMessage, WPARAM wparam, LPARAM lparam)
{
	int imsd;
	MSD *rgmsd = lpmsdi->rgmsd;
   int cmsd  = lpmsdi->cmsd;

   for (imsd = 0; imsd < cmsd; imsd++) {
   	if (rgmsd[imsd].uMessage == uMessage)
      	return rgmsd[imsd].pfnmsg(hwnd, uMessage, wparam, lparam);
   }
	return DispDefault(lpmsdi->edwp, hwnd, uMessage, wparam, lparam);
}
LRESULT DispCommand(LPCMDI lpcmdi, HWND hwnd, WPARAM wparam, LPARAM lparam)
{
	WORD wCommand = GET_WM_COMMAND_ID(wparam, lparam);
   int icmd;
	CMD *rgcmd = lpcmdi->rgcmd;
   int ccmd  = lpcmdi->ccmd;

   for (icmd = 0; icmd < ccmd; icmd++) {
   	if (rgcmd[icmd].wCommand == wCommand) {
      	return rgcmd[icmd].pfncmd(hwnd, wCommand, GET_WM_COMMAND_CMD(wparam, lparam), GET_WM_COMMAND_HWND(wparam, lparam));
      }
   }
	return DispDefault(lpcmdi->edwp, hwnd, WM_COMMAND, wparam, lparam);
}
LRESULT DispDefault(EDWP edwp, HWND hwnd, UINT uMessage, WPARAM wparam, LPARAM lparam)
{
	switch (edwp) {
   	case edwpNone:
      	return 0;
      case edwpWindow:
      	return DefWindowProc(hwnd, uMessage, wparam, lparam);
      case edwpDialog:
      	return DefDlgProc(hwnd, uMessage, wparam, lparam);
    }
    return 0;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT uMessage, WPARAM wparam, LPARAM lparam)
{
    return DispMessage(&msdiMain, hwnd, uMessage, wparam, lparam);
}
#pragma argsused
LRESULT MsgCommand(HWND hwnd, UINT uMessage, WPARAM wparam, LPARAM lparam)
{
   return DispCommand(&cmdiMain, hwnd, wparam, lparam);
}
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
#pragma argsused
LRESULT MsgInit(HWND hwnd, UINT uMessage, WPARAM wparam, LPARAM lparam)
{
   TC_ITEM tie;
   HWND hwTab = GetDlgItem(hwnd, IDC_PTIMES_TAB);
   HIMAGELIST hTabImageList;
   HICON hIcon;

   hwndMain = hwnd;
   savcfg(FALSE);
   dwVersion = GetVersion();
   dwVer = LOBYTE(LOWORD(dwVersion));
   if ((dwVersion < 0x80000000) && (dwVer == 4)) bWindowsNT = TRUE;
   else bWindowsNT = FALSE;

   samFont[0] = CreateSamFont(400, 0, 10, DEFAULT_CHARSET, "Small Fonts");
   samFont[1] = CreateSamFont(400, 0, 13, DEFAULT_CHARSET, "MS Sans Serif");

   cr_red = RGB(255,0,0);
   cr_green = RGB(0,164,0);
   hBrushGreen = CreateSolidBrush(cr_green);
   hBrushBlue = CreateSolidBrush(RGB(192,128,192));
	SamSysColors();


   SendMessage(hwTab, TCM_SETITEMSIZE, (WPARAM)24, (LPARAM)24);
   hTabImageList = ImageList_Create(16, 16, TRUE, 4, 0);
   hIcon = LoadIcon(hInst, "IDI_TAB_CALCULATE");
   tie.iImage = (int)ImageList_AddIcon(hTabImageList, hIcon);
   DestroyIcon(hIcon);

   hIcon = LoadIcon(hInst, "IDI_TAB_TEXT");
   tie.iImage = (int)ImageList_AddIcon(hTabImageList, hIcon);
   DestroyIcon(hIcon);

   hIcon = LoadIcon(hInst, "IDI_TAB_CALENDAR");
   tie.iImage = (int)ImageList_AddIcon(hTabImageList, hIcon);
   DestroyIcon(hIcon);

   hIcon = LoadIcon(hInst, "IDI_TAB_ANIMATION");
   tie.iImage = (int)ImageList_AddIcon(hTabImageList, hIcon);
   DestroyIcon(hIcon);

   hIcon = LoadIcon(hInst, "IDI_TAB_AUTHOR");
   tie.iImage = (int)ImageList_AddIcon(hTabImageList, hIcon);
   DestroyIcon(hIcon);

   SendMessage(hwTab, TCM_SETIMAGELIST, (WPARAM)0, (LPARAM)(HIMAGELIST)hTabImageList);

   tie.mask = TCIF_TEXT | TCIF_IMAGE;
   tie.pszText = "Praying times calculation";
   tie.iImage = 0;
   TabCtrl_InsertItem(hwTab, 0, &tie);

   tie.pszText = "Praying times view";
   tie.iImage = 1;
   TabCtrl_InsertItem(hwTab, 1, &tie);

   tie.pszText = "Hijri / Gregorian calendar";
   tie.iImage = 2;
   TabCtrl_InsertItem(hwTab, 2, &tie);

   tie.pszText = "Praying animation";
   tie.iImage = 3;
   TabCtrl_InsertItem(hwTab, 3, &tie);

   tie.pszText = "Author";
   tie.iImage = 4;
   TabCtrl_InsertItem(hwTab, 4, &tie);

	TabCtrl_SetCurSel(hwTab, 0);
   ChangeTab(hwnd);

	return TRUE;
}
#pragma argsused
LRESULT MsgNotify(HWND hwnd, UINT uMessage, WPARAM wparam, LPARAM lparam)
{
	UINT code = ((LPNMHDR)lparam)->code;
   if (code == TCN_SELCHANGE) ChangeTab(hwnd);
   return 0;
}
#pragma argsused
LRESULT MsgClose(HWND hwnd, UINT uMessage, WPARAM wparam, LPARAM lparam)
{
   savcfg(TRUE);
   EndDialog(hwnd, TRUE);
   return 0;
}
#pragma argsused
LRESULT CmdExit(HWND hwnd, WORD wCommand, WORD wNotify, HWND hwndCtrl)
{
   savcfg(TRUE);
	EndDialog(hwnd, TRUE);
   return 0;
}
void SamSysColors(void)
{
   cr_tool = GetSysColor(COLOR_MENU);
	cr_gray = GetSysColor(COLOR_GRAYTEXT);

   if (bWindowsNT == TRUE) {
	   cr_light = RGB(224,224,224);
   	cr_white = RGB(255,255,255);
	   cr_black = RGB(0,0,0);
   }
   else {
	   cr_light = GetSysColor(COLOR_3DLIGHT);
   	cr_white = GetSysColor(COLOR_3DHILIGHT);
	   cr_black = GetSysColor(COLOR_3DDKSHADOW);
   }
   if (hBrushGray) DeleteObject(hBrushGray);
   hBrushGray = CreateSolidBrush(cr_gray);

   if (hBrushTool) DeleteObject(hBrushTool);
   hBrushTool = CreateSolidBrush(cr_tool);

   if (hBrushLight) DeleteObject(hBrushLight);
   hBrushLight = CreateSolidBrush(cr_light);
}

DLGTEMPLATE * WINAPI DoLockDlgRes(LPCSTR lpszResName)
{
    HRSRC hrsrc = FindResource(NULL, lpszResName, RT_DIALOG);
    HGLOBAL hglb = LoadResource(hInst, hrsrc);
    return (DLGTEMPLATE *) LockResource(hglb);
}
VOID WINAPI ChangeTab(HWND hwnd)
{
   HWND hwndTab = GetDlgItem(hwnd, IDC_PTIMES_TAB);
   int iSel = TabCtrl_GetCurSel(hwndTab);

   if (hwndCurTab != NULL) DestroyWindow(hwndCurTab);
   curTab = iSel;
   if ((iSel >= 0) && (iSel < NUM_TABS))
   if (iSel == 0)
   	hwndCurTab = CreateDialogIndirect(hInst, DoLockDlgRes("IDD_PT_OPTIONS"), hwndTab, (DLGPROC)PrayingTimesProc);
   else if (iSel == 1)
   	hwndCurTab = CreateDialogIndirect(hInst, DoLockDlgRes("IDD_PT_TEXT"), hwndTab, (DLGPROC)TextProc);
   else if (iSel == 2)
   	hwndCurTab = CreateDialogIndirect(hInst, DoLockDlgRes("IDD_PT_CALENDAR"), hwndTab, (DLGPROC)CalendarProc);
   else if (iSel == 3)
   	hwndCurTab = CreateDialogIndirect(hInst, DoLockDlgRes("IDD_PT_ANIMATION"), hwndTab, (DLGPROC)AnimationProc);
   else if (iSel == 4)
   	hwndCurTab = CreateDialogIndirect(hInst, DoLockDlgRes("IDD_PT_AUTHOR"), hwndTab, (DLGPROC)AuthorProc);
}
void SetTabChildPos(HWND hwnd)
{
 	SetWindowPos(hwnd, HWND_TOP, 12, 28, 0, 0, SWP_NOSIZE);
}
#pragma argsused
LRESULT CALLBACK PrayingTimesProc(HWND hdlg, UINT message, WPARAM wParam, LPARAM lParam)
{
   switch (message) {
   	case WM_INITDIALOG: {
         FILE *f;
		   HWND hwid;
		   int i, ix, g, cSelected=0;
         double lt, lg;
		   char buffer[50], buf[50];
		   SYSTEMTIME  sTime;

         SetTabChildPos(hdlg);
		   GetLocalTime(&sTime);

			cday = sTime.wDay;
		   cmonth = sTime.wMonth;
		   cyear = sTime.wYear;
		   hwid = GetDlgItem(hdlg, IDC_PT_COMBO_MONTH);
		   for(i=1; i<13; i++) {
		      wsprintf(buffer, "%d", i);
		   	ix = SendMessage(hwid, CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)buffer);
		      SendMessage(hwid, CB_SETITEMDATA, ix, i-1);
		   }
			SendMessage(hwid, CB_SETCURSEL, sTime.wMonth-1, 0L);

		   hwid = GetDlgItem(hdlg, IDC_PT_COMBO_YEAR);
		   for(i=sTime.wYear; i<sTime.wYear+20; i++) {
		      wsprintf(buffer, "%d", i);
		   	ix = SendMessage(hwid, CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)buffer);
		      SendMessage(hwid, CB_SETITEMDATA, ix, i-sTime.wYear);
		   }
			SendMessage(hwid, CB_SETCURSEL, 0, 0L);

         if ((f=fopen(strFilePrayData, "r")) != NULL) {
			   hwid = GetDlgItem(hdlg, IDC_PT_TOWN_NAME);
            i = 0;
            while (feof(f) == 0) {
            	ZeroMemory(buffer, sizeof(buffer)); g = 0;
               while (((buffer[g] = (char)fgetc(f)) != ';') && (g < 50)) g++;
               buffer[g] = '\0';
               ZeroMemory(buf, sizeof(buf)); g = 0;
               while (((buf[g] = (char)fgetc(f)) != ';') && (g < 50)) g++;
               buf[g] = '\0';
               lt = atof(buf);
               ZeroMemory(buf, sizeof(buf)); g = 0;
               while (((buf[g] = (char)fgetc(f)) != ';') && (g < 50)) g++;
               buf[g] = '\0';
               lg = atof(buf);
               while ((feof(f) == 0) && (fgetc(f) != '\n'));
			   	ix = SendMessage(hwid, CB_ADDSTRING, 0, (LPARAM)(LPCTSTR)buffer);
		   	   SendMessage(hwid, CB_SETITEMDATA, ix, i);
               if ((strcmpi(strNameTown, buffer) == 0) && (lt == latitude) && (lg == longitude)) cSelected = i;
               i++;
			   }
            fclose(f);
         }
			SendMessage(hwid, CB_SETCURSEL, cSelected, 0L);
		   SetDlgItemText(hdlg, IDE_PT_TOWN_NAME, strNameTown);

		   sprintf(strVarious, "%f", latitude);
         strVarious[5] = '\0';
		   SetDlgItemText(hdlg, IDE_PT_LATITUDE, strVarious);
		   sprintf(strVarious, "%f", longitude);
         strVarious[5] = '\0';
		   SetDlgItemText(hdlg, IDE_PT_LONGITUDE, strVarious);
		   SetDlgItemInt(hdlg, IDE_PT_TIMEZONE, TimeZone, TRUE);
         }
			return TRUE;

      case WM_CLOSE:
      	PostMessage(hdlg, WM_COMMAND, IDCANCEL, 0L);
         break;
      case WM_COMMAND:
      	switch (GET_WM_COMMAND_ID(wParam, lParam)) {
            case IDB_PT_TOWN_NAME: {
            	FILE *f;
               int g;
		         double lt, lg;
               char buffer[50], buf[50];

				   GetDlgItemText(hdlg, IDE_PT_LATITUDE, strVarious, 10);
				   latitude = atof(strVarious);
				   GetDlgItemText(hdlg, IDE_PT_LONGITUDE, strVarious, 10);
				   longitude = atof(strVarious);
				   GetDlgItemText(hdlg, IDE_PT_TOWN_NAME, strNameTown, 100);
               if ((f=fopen(strFilePrayData, "r")) != NULL) {
                  while (feof(f) == 0) {
                  	ZeroMemory(buffer, sizeof(buffer)); g = 0;
                     while (((buffer[g] = (char)fgetc(f)) != ';') && (g < 50)) g++;
                     buffer[g] = '\0';
                     ZeroMemory(buf, sizeof(buf)); g = 0;
                     while (((buf[g] = (char)fgetc(f)) != ';') && (g < 50)) g++;
                     buf[g] = '\0';
                     lt = atof(buf);
                     ZeroMemory(buf, sizeof(buf)); g = 0;
                     while (((buf[g] = (char)fgetc(f)) != ';') && (g < 50)) g++;
                     buf[g] = '\0';
                     lg = atof(buf);
		               while ((feof(f) == 0) && (fgetc(f) != '\n'));
		               if ((strcmpi(strNameTown, buffer) == 0) && (lt == latitude) && (lg == longitude)) {
		               	MessageBox(hdlg, "This Town information already exist", szAppName, MB_OK | MB_ICONSTOP);
		               	fclose(f); f=NULL;
                     	break;
                     }
                  }
               	if (f) {
                  	fclose(f);
		               if ((f=fopen(strFilePrayData, "a")) != NULL) {
                        fprintf(f, "%s;%.02f;%.02f;\n", strNameTown, latitude, longitude);
	                  	fclose(f);
                     }
                  }
               }
            	}
               break;
            case IDC_PT_TOWN_NAME: {
				   int ind;
					if (GET_WM_COMMAND_CMD(wParam, lParam) ==  CBN_SELENDOK) {
				   	ind = SendMessage(GetDlgItem(hdlg, IDC_PT_TOWN_NAME), CB_GETCURSEL, 0, 0L);
				      if (ind != CB_ERR) {
				         FILE *f;
                     int i, g;
						   char buf[50];

				         if ((f=fopen(strFilePrayData, "r")) != NULL) {
				            i = 0;
				            while (feof(f) == 0) {
                        	if (i == ind) {
					            	ZeroMemory(strNameTown, sizeof(strNameTown)); g = 0;
					               while (((strNameTown[g] = (char)fgetc(f)) != ';') && (g < 50)) g++;
                              strNameTown[g] = '\0';
									   SetDlgItemText(hdlg, IDE_PT_TOWN_NAME, strNameTown);
				   	            ZeroMemory(buf, sizeof(buf)); g = 0;
				      	         while (((buf[g] = (char)fgetc(f)) != ';') && (g < 50)) g++;
			                     buf[g] = '\0';
			   	      	      latitude = atof(buf);
									   sprintf(strVarious, "%f", latitude);
							         strVarious[5] = '\0';
									   SetDlgItemText(hdlg, IDE_PT_LATITUDE, strVarious);
			      	      	   ZeroMemory(buf, sizeof(buf)); g = 0;
				      	         while (((buf[g] = (char)fgetc(f)) != ';') && (g < 50)) g++;
			                     buf[g] = '\0';
				         	      longitude = atof(buf);
									   sprintf(strVarious, "%f", longitude);
							         strVarious[5] = '\0';
									   SetDlgItemText(hdlg, IDE_PT_LONGITUDE, strVarious);
				               	fclose(f); f=NULL;
                              break;
								   }
                           else while ((feof(f) == 0) && (fgetc(f) != '\n'));
                           i++;
                        }
				            if (f) fclose(f);
				         }
                  }
				   }
            	}
           	 	break;

            case IDB_PT_TIMEZONE: {
				   int zone;
               DWORD dwRet;
				   TIME_ZONE_INFORMATION tz;

				   dwRet = GetTimeZoneInformation(&tz);
               zone = tz.Bias;
               if (dwRet == 0xFFFFFFFF) {
               	MessageBox(hdlg, "Can get time zone", szAppName, MB_OK | MB_ICONSTOP);
                  break;
               }
               else if (dwRet == TIME_ZONE_ID_DAYLIGHT) {
               	MessageBox(hdlg, "TIME_ZONE_ID_DAYLIGHT", szAppName, MB_OK | MB_ICONSTOP);
                  zone += tz.DaylightBias;
               }
               else zone += tz.StandardBias;

               TimeZone = -(zone / 60);
               sprintf(strVarious, "%d", TimeZone);
               SetDlgItemText(hdlg, IDE_PT_TIMEZONE, strVarious);
               }
               break;
            case IDB_PT_CALCULATE: {
               HWND hwndTab = GetDlgItem(hwndMain, IDC_PTIMES_TAB);
				   GetDlgItemText(hdlg, IDE_PT_LATITUDE, strVarious, 10);
				   latitude = atof(strVarious);

				   GetDlgItemText(hdlg, IDE_PT_LONGITUDE, strVarious, 10);
				   longitude = atof(strVarious);

				   TimeZone = GetDlgItemInt(hdlg, IDE_PT_TIMEZONE, NULL, TRUE);

				   GetDlgItemText(hdlg, IDE_PT_TOWN_NAME, strNameTown, 100);

					PrayingTimesCalculation(strFilePrayTime, (double)TimeZone, longitude, latitude, cyear, cmonth, cday, 0);
					SendMessage(hwndTab, TCM_SETCURSEL, 1, 0L);
               ChangeTab(hwndMain);
					//PostMessage(hwndMain, TCN_SELCHANGE, 1, (LPARAM)(HWND)hwndTab);
               }
               break;

            case IDCANCEL:
               break;

         	default:
	            return FALSE;
         }
	      break;

      default:
   	   return FALSE;
   }
   return TRUE;
}
#pragma argsused
LRESULT CALLBACK TextProc(HWND hdlg, UINT message, WPARAM wParam, LPARAM lParam)
{
   switch (message) {
   	case WM_INITDIALOG: {
		   FILE *ftt;
		   DWORD dwfSize;
		   HANDLE hFilePT;
		   LPSTR lpFilePT;

		   SendMessage(GetDlgItem(hdlg, IDE_PTIMES_RESULT), WM_SETFONT, (WPARAM)(HFONT)GetStockObject(SYSTEM_FIXED_FONT), TRUE);
         SetTabChildPos(hdlg);
		   if ((dwfSize = filesize(strFilePrayTime)) == 0) return TRUE;
		   if ((hFilePT = LocalAlloc(LHND, dwfSize+10)) == NULL) return TRUE;
		   if ((lpFilePT = LocalLock(hFilePT)) == NULL) { LocalFree(hFilePT); return TRUE; }
			if ((ftt = fopen(strFilePrayTime, "rb")) == NULL) return TRUE;
		   fread(lpFilePT, 1, dwfSize, ftt);
		   fclose(ftt);
		   SetDlgItemText(hdlg, IDE_PTIMES_RESULT, (LPSTR)lpFilePT);
		   LocalUnlock(hFilePT);
		   LocalFree(hFilePT);
         }
			return FALSE;

      case WM_CLOSE:
      	PostMessage(hdlg, WM_COMMAND, IDCANCEL, 0L);
         break;
      case WM_COMMAND:
      	switch (GET_WM_COMMAND_ID(wParam, lParam)) {
            case IDCANCEL:
               break;

         	default:
	            return FALSE;
         }
	      break;

      default:
   	   return FALSE;
   }
   return TRUE;
}
#pragma argsused
LRESULT CALLBACK CalendarProc(HWND hdlg, UINT message, WPARAM wParam, LPARAM lParam)
{
   switch (message) {
   	case WM_INITDIALOG: {
         SYSTEMTIME st;
         SetTabChildPos(hdlg);

         GetLocalTime(&st);
			GregFirstDayWeek(st);
         GregYear = st.wYear;
         GregMonth = st.wMonth;
         GregDay = st.wDay;
         GregDayWeek = st.wDayOfWeek;
		   GDateAjust(&GregYear, &GregMonth, &GregDay);
		  	G2HA(GregYear, GregMonth, GregDay, &HijriYear, &HijriMonth, &HijriDay, &HijriDayWeek);
		   UpdateHijri(hdlg, 1);
         }
			return TRUE;

      case WM_DRAWITEM: {
		   DRAWITEMSTRUCT *lpdis = (LPDRAWITEMSTRUCT) lParam;
   		PaintOneMonth(lpdis->hwndItem, lpdis->hDC, lpdis->CtlID - IDP_DATE_JANUARY + 1);
         }
      	break;

      case WM_CLOSE:
      	PostMessage(hdlg, WM_COMMAND, IDCANCEL, 0L);
         break;
      case WM_COMMAND:
      	switch (GET_WM_COMMAND_ID(wParam, lParam)) {
		      case IDC_DATE_GREGORIAN:
      		   bHijri = FALSE;
		         UpdateHijri(hdlg, 0);
			      break;
				case IDC_DATE_HIJRI:
		         bHijri = TRUE;
		         UpdateHijri(hdlg, 0);
			      break;
            case IDCANCEL:
				   bHijri = SendDlgItemMessage(hdlg, IDC_DATE_HIJRI, BM_GETCHECK, 0, 0L);
               break;

         	default:
	            return FALSE;
         }
	      break;

      default:
   	   return FALSE;
   }
   return TRUE;
}
void SetNameMonths(HWND hwnd)
{
   int w;

   for(w=0; w<12; w++) {
		if (bHijri == FALSE) SetDlgItemText(hwnd, IDT_DATE_JANUARY+w, (LPSTR)GregMonths[w]);
      else SetDlgItemText(hwnd, IDT_DATE_JANUARY+w, (LPSTR)HijriMonths[w]);
	}
}
void UpdateHijri(HWND hdlg, WORD yr)
{
   SendDlgItemMessage(hdlg, IDC_DATE_GREGORIAN+bHijri, BM_SETCHECK, 1, 0L);
   SetNameMonths(hdlg);
   wsprintf(strVarious, "%d", HijriYear);
   SetDlgItemText(hdlg, IDC_DATE_YEARH, (LPSTR)strVarious);

   wsprintf(strVarious, "%d", GregYear);
   SetDlgItemText(hdlg, IDC_DATE_YEARG, (LPSTR)strVarious);
   if (yr != 1) {
		WORD u;
      for(u=0; u<12; u++) PaintOneMonth(GetDlgItem(hdlg, IDP_DATE_JANUARY+u), NULL, u+1);
   }
}
#pragma argsused
void PaintOneMonth(HWND hwnd, HDC hdc, int month)
{
   char mont[8] = "SMTWTFS";
   char tn[4];
   int x, y, m, c, d;
   int lenM=0, dayweek;
   double jd;
   RECT rc, rc2, rc3;
   BOOL bHdc=FALSE;
   HFONT hOldFont;

   if (hdc == NULL) { bHdc=TRUE; hdc = GetDC(hwnd); }
   GetClientRect(hwnd, &rc);
   rc2 = rc3 = rc;
   rc2.bottom = 17;
   rc3.top = 17;

   if (bHijri == TRUE) {
   	lenM = (int)HMonthLength(HijriYear, month);
		jd = HCalendarToJDA(HijriYear, month, 1);
	   dayweek = (int)DayWeek((long)jd);
   }
   else dayweek = FirstDay[month];

   if (((bHijri == TRUE) && (HijriMonth == month)) || ((bHijri == FALSE) && (GregMonth == month)))
   	FillRect(hdc, &rc2, hBrushBlue);
   else FillRect(hdc, &rc2, hBrushGreen);
   FillRect(hdc, &rc3, hBrushLight);

   for (x=1; x<7; x++) BrziSamLine(hdc, x*18, 0, 0, rc.bottom, cr_tool, 1);
   for (x=1; x<7; x++) BrziSamLine(hdc, 0, x*15, rc.right, 0, cr_tool, 1);

	hOldFont = SelectObject(hdc, samFont[0]);
	SetBkMode(hdc, TRANSPARENT);
   SetTextColor(hdc, cr_white);

   for (x=0; x<7; x++) {
      if (x == 3) TextOut(hdc, (x*18)+4, 2, &mont[x], 1);
   	else TextOut(hdc, (x*18)+6, 2, &mont[x], 1);
   }
   SetTextColor(hdc, cr_black);

   c = dayweek;
   d = 0;
   for (y=1; y<7; y++) {
   	for (x=c; x<7; x++) {
      	if (y == 1) { m = x - c + 1; d++; }
         else m = ((y-2)*7)+x+1+d;
         if (m < 0) { x=7; y=7; break; }
         if (((bHijri == FALSE) && (m <= gmonth[month])) || ((bHijri == TRUE) && (m <= lenM))) {
         	wsprintf(tn, "%d", m);
            if (((bHijri == FALSE) && (GregMonth == month) && (GregDay == m)) ||
            	((bHijri == TRUE) && (HijriMonth == month) && (HijriDay == m))) {
               SetTextColor(hdc, cr_red);
               TextOut(hdc, (x*18)+7-(lstrlen(tn)*2), (y*12)+6, tn, lstrlen(tn));
               SetTextColor(hdc, cr_black);
            }
            else TextOut(hdc, (x*18)+7-(lstrlen(tn)*2), (y*12)+6, tn, lstrlen(tn));
         }
         else { x=7; y=7; break; }
      }
      c = 0;
   }
   if (hOldFont) SelectObject(hdc, hOldFont);
   if (bHdc == TRUE) ReleaseDC(hwnd, hdc);
}
void GregFirstDayWeek(SYSTEMTIME sg)
{
	WORD a, b;

   while(sg.wDay > 1) {
   	sg.wDay -= (WORD)1;
      if (sg.wDayOfWeek == 0) sg.wDayOfWeek = 6;
      else sg.wDayOfWeek -= (WORD)1;
   }
   while(sg.wMonth > 1) {
   	sg.wMonth -= (WORD)1;
      for(a=0; a<gmonth[sg.wMonth]; a++) {
      	if (sg.wDayOfWeek == 0) sg.wDayOfWeek = 6;
         else sg.wDayOfWeek -= (WORD)1;
      }
   }
   FirstDay[1] = sg.wDayOfWeek;
   for(a=1; a<12; a++) {
   	for(b=0; b<gmonth[a]; b++) {
      	if (sg.wDayOfWeek >= 6) sg.wDayOfWeek = 0;
         else sg.wDayOfWeek += (WORD)1;
      }
      FirstDay[a+1] = sg.wDayOfWeek;
   }
}
#pragma argsused
LRESULT CALLBACK AuthorProc(HWND hdlg, UINT message, WPARAM wParam, LPARAM lParam)
{
   switch (message) {
   	case WM_INITDIALOG:
         SetTabChildPos(hdlg);
			InitAboutList(GetDlgItem(hdlg, IDC_AUTHOR_LISTBOX));
			return TRUE;

      case WM_CLOSE:
      	PostMessage(hdlg, WM_COMMAND, IDCANCEL, 0L);
         break;
      case WM_COMMAND:
      	switch (GET_WM_COMMAND_ID(wParam, lParam)) {
            case IDC_FREE: case IDC_FREE2: {
				   char sita[256];
					HINSTANCE hiex;

				   if (GET_WM_COMMAND_ID(wParam, lParam) == IDB_FREE3) strcpy(sita, "http://www.2muslims.com/cgi-bin/links/rc_handle.cgi?CODE=0&ID=7182");
				   else if (GET_WM_COMMAND_ID(wParam, lParam) == IDC_FREE) strcpy(sita, "http://www.agnatemoslem.net");
				   else strcpy(sita, "http://www.yildun.com");

				   hiex = ShellExecute(hwndMain, "open", "Iexplore.exe", sita, workdir, SW_SHOW);
				   if (hiex <= (HINSTANCE)32) hiex = ShellExecute(hwndMain, "open", "Netscape.exe", sita, workdir, SW_SHOW);
				   if (hiex <= (HINSTANCE)32) MessageBox(hdlg, "Error while opening Netscape.exe or Iexplore.exe", NULL, MB_OK);
				   else {
					   EndDialog(hdlg, FALSE);
				   	ShowWindow(hwndMain, SW_SHOWMINIMIZED);
				   }
               }
               break;
            case IDCANCEL:
               break;

         	default:
	            return FALSE;
         }
	      break;

      default:
   	   return FALSE;
   }
   return TRUE;
}
#pragma argsused
BOOL InitAboutList(HWND hdlg)
{
   int u, imageIcon;
   HICON hIcon;
   LV_COLUMN lvc = {0};

	lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
   lvc.fmt= LVCFMT_LEFT;
   lvc.iSubItem = 0;

   lvc.pszText = "Other Author softwares";
   lvc.cx = 540;
   ListView_InsertColumn(hdlg, 0, &lvc);


   if ((hImageAboutList = ImageList_Create(16, 16, TRUE, 0, 0)) == NULL) {
   	MessageBox(hwndMain, "Can't create image list", NULL, MB_ICONSTOP | MB_OK);
      return FALSE;
   }
   imageIcon = ImageList_AddIcon(hImageAboutList, hIcon=LoadIcon(hInst, "IDI_APPICON"));
   SendMessage(hdlg, LVM_SETIMAGELIST, (WPARAM)(int)LVSIL_SMALL, (LPARAM)(HIMAGELIST)hImageAboutList);

   if (hIcon) DeleteObject(hIcon);

   for(u=0; u<ABOUT_LINES; u++) AddAboutListItem(hdlg, imageIcon, u, aboutLine[u]);
   return TRUE;
}
#pragma argsused
BOOL AddAboutListItem(HWND hdlg, int image, int n, char *text)
{
	LV_ITEM lvi = {0};

   lvi.mask      = LVIF_TEXT | LVIF_STATE | LVIF_IMAGE;
   lvi.iItem     = n;
   lvi.iSubItem  = 0;
   lvi.state     = 0;
   lvi.stateMask = 0;
   lvi.pszText   = text;
   lvi.cchTextMax = MAX_PATH;
   lvi.iImage    = image;
	lvi.lParam    = 0L;
	return ListView_InsertItem(hdlg, &lvi);
}


long filesize(char *source)
{
   FILE *stream;
   long curpos, length;

   if ((stream = fopen(source, "rb")) != NULL) {
	   curpos = ftell(stream);
   	fseek(stream, 0L, SEEK_END);
	   length = ftell(stream);
   	fseek(stream, curpos, SEEK_SET);
	   return length;
   }
   return 0;
}

void savcfg(BOOL ft)
{
   FILE *fo;
   char cfo[MAX_PATH];

   ZeroMemory(cfo, MAX_PATH);
   strcpy(cfo, workdir); strcat(cfo, "\\praytime.cfg");
   if (ft == FALSE) {
   	if ((fo = fopen(cfo, "rb")) != NULL) {
	      fread(&latitude, sizeof(double), 1, fo);
	      fread(&longitude, sizeof(double), 1, fo);
         ZeroMemory(strNameTown, sizeof(strNameTown));
	      fread(strNameTown, sizeof(char), MAX_PATH, fo);
   	   fread(&TimeZone, sizeof(int), 1, fo);
         fclose(fo);
      }
   }
   else if ((fo = fopen(cfo, "wb")) != NULL) {
   	fwrite(&latitude, sizeof(double), 1, fo);
      fwrite(&longitude, sizeof(double), 1, fo);
      fwrite(strNameTown, sizeof(char), MAX_PATH, fo);
      fwrite(&TimeZone, sizeof(int), 1, fo);
      fclose(fo);
	}
}


/*
// time zone test

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <sys\timeb.h>
#include <windows.h>
#include <process.h>
#include <errno.h>
#include <process.h>


#define BIAS1 ( *((DWORD*)0x7FFe0020) )
#define BIAS2 ( *((DWORD*)0x7FFe0024) )

CHAR buf[200];   // message buffer

VOID FormatSt( SYSTEMTIME st, CHAR* buf)
{
    sprintf(buf,"%02d/%02d/%02d %02d:%02d:%02d",
        st.wYear, st.wMonth, st.wDay,
        st.wHour, st.wMinute, st.wSecond );
}

VOID PrintTZInfo()
{
    TIME_ZONE_INFORMATION tzi;
    DWORD dwSta;

    dwSta= GetTimeZoneInformation( &tzi );

    printf("GetTimeZoneInformation: \n ");
    switch( dwSta )
    {
        case TIME_ZONE_ID_UNKNOWN:
            printf("returned TIME_ZONE_ID_UNKNOWN\n");
            break;

        case TIME_ZONE_ID_STANDARD:
            FormatSt( tzi.StandardDate, buf );
            printf("Bias %d  Name: %S  SysDate: %s  Bias: %d\n",
                   tzi.Bias, tzi.StandardName, buf, tzi.StandardBias );
            break;

        case TIME_ZONE_ID_DAYLIGHT:
            FormatSt( tzi.DaylightDate, buf );
            printf("Bias %d  Name: %S  SysDate: %s  Bias: %d\n",
                   tzi.Bias, tzi.DaylightName, buf, tzi.DaylightBias );
            break;

        default:
            printf("returned undoced status: %d",dwSta);
            break;
    }
    printf(" User_Shared_Data bias: %08x %08x\n\n",BIAS2, BIAS1 );
}

VOID TstSetTime( int year, int mon, int day, int hour, int minute, int sec)
{
    SYSTEMTIME st,tst;
    BOOL bSta;

    st.wYear=  year;
    st.wMonth= mon;
    st.wDay=   day;
    st.wHour=  hour;
    st.wMinute= minute;
    st.wSecond= sec;

    st.wDayOfWeek= 0;
    st.wMilliseconds= 0;

    bSta= SetLocalTime( &st );

    if( bSta == FALSE )
    {
        FormatSt( st, buf);
        printf("Failed to set date/time: %s\n",buf);
    }
    else
    {
        FormatSt( st, buf);
        printf("SetLocalTime:  %s\n",buf);

        GetLocalTime( &tst );
        FormatSt( tst, buf);
        printf("GetLocalTime:  %s\n", buf);

        GetSystemTime( &tst );
        FormatSt( tst, buf );
        printf("GetSystemTime: %s\n", buf);
    }
    printf("\n");

}

VOID PrintTime( CHAR* msg )
{
    SYSTEMTIME st;

    GetLocalTime( &st );

    FormatSt( st, (CHAR*) buf );

    printf("%s %s\n", msg, buf);

}

int _cdecl  main(int argc, char** argv)
{

    // pick date in savings time

    TstSetTime( 1998, 8, 30, 22, 59, 0 );
    PrintTZInfo();

    // pick date outside of savings time

    printf("\n");
    TstSetTime( 1998, 12, 29, 22, 59, 0 );
    PrintTZInfo();

    return(0);
}
*/

