/* ISLAMIC PRAYERS *****************************************\
 *                                                         *
 *  2004-2006 By Samir Alicehajic (samir@yildun.com)       *
 *  http://www.yildun.com                                  *
 *  Copyright (C) 2004-2006 Samir Alicehajic               *
 *  THIS SOURCE CODE IS FREE FOR USE IN THE NAME OF        *
 *	 ALLAH SUBHANAHU WA TA'ALA                              *
 *  This SOURCE CODE is distributed in the hope that it    *
 *  will be useful, but WITHOUT ANY WARRANTY; without even *
 *  the implied warranty of MERCHANTABILITY or             *
 *  FITNESS FOR A PARTICULAR PURPOSE.                      *
 *  However you can use part of this source code in your   *
 *  own software                                           *
 *                                                         *
\***********************************************************/

#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <stdio.h>
#include <math.h>
#include "praytimes.h"
#include "resource.h"

#define NUM_PRAYERS 12
#define NUM_PRAY_PICTURES 44
#define ID_TIMER_PRAYING 3646
#define WIDTHBYTES(bits)      ((((bits) + 31) & ~31) >> 3)

extern void SetTabChildPos(HWND hwnd);

int CurrentNumText=0;

HBITMAP hBitmap=NULL;
HPALETTE hPalette=NULL;
HANDLE hInfo=NULL;
LPVOID lpvBits=NULL;
DWORD EditImageSize, BitSize;

char strAnimNotes[4096], strAnimNotesTemp[4096];
int CurrentPicture=0, CurrentPraying=0, CurrentSalat=0, CurrentDelay=0, CurrentRekat=0;
int CurrentMuski, CurrentZenski, CurrentAnim=0;
UINT pCurrentText=0, CurrentText=0;
BOOL VratiAnim, AnimLoaded=FALSE;
BYTE Rekati[13]={2, 2,  4, 4, 2,  4, 4,  3, 2,  4, 4, 2, 3};
UINT wCommandAnim, idTimer=0, DelayPrayer=100;
POINT whBitmap={120*5,120};
LPVOID lpvPray[NUM_PRAY_PICTURES];
int xPray[NUM_PRAY_PICTURES], yPray[NUM_PRAY_PICTURES];
DWORD xBitPray[NUM_PRAY_PICTURES];

char strAnimPrayers[NUM_PRAYERS][MAX_PATH]=
{
{"1) Fajr             2 rakats    obligatori            morning"},
{"1) Fajr             2 rakats    non-obligatori     morning"},
{"2) Zuhr           4 rakats    obligatori            afternoon"},
{"2) Zuhr           4 rakats    non-obligatori     afternoon"},
{"2) Zuhr           2 rakats    non-obligatori     afternoon"},
{"3) Asr             4 rakats    obligatori            beetwen afternoon and evening"},
{"3) Asr             4 rakats    non-obligatori     beetwen afternoon and evening"},
{"4) Maghrib      3 rakats    obligatory          evening"},
{"4) Maghrib      2 rakats    non-obligatory   evening"},
{"5) Isha            4 rakats    obligatori           night"},
{"5) Isha            4 rakats    non-obligatori    night"},
{"5) Isha-Witr     3 rakats    obligatori           night"},
};



int DisplayAnimations(HWND hdlg, HDC hDC, int anim);
void PicturePray(int xp, int yp, BYTE pct);
int CreateCurBitmap(void);
int FillColorTable(LPRGBQUAD lpColorTable);
void PictureProcess(void);
void ReStartPraying(HWND hdlg);

LRESULT CALLBACK AnimationProc(HWND, UINT, WPARAM, LPARAM);

#pragma argsused
LRESULT CALLBACK AnimationProc(HWND hdlg, UINT message, WPARAM wparam, LPARAM lparam)
{
   switch (message) {
   	case WM_INITDIALOG: {
		   HRSRC hSrc;
		   HGLOBAL hgSrc;
		   LPVOID dataSrc;
		   int kh, nIndex;
         HWND hwndC = GetDlgItem(hdlg, IDC_ANIM_COMBO);

         SetTabChildPos(hdlg);

			for (kh = 0; kh < NUM_PRAYERS; kh++) {
		   	nIndex = SendMessage(hwndC, CB_ADDSTRING, 0, (LPARAM)(LPSTR)strAnimPrayers[kh]);
		      SendMessage(hwndC, CB_SETITEMDATA, nIndex, kh);
		   }
         SendMessage(hwndC, CB_SETCURSEL, CurrentPraying, 0L);

         SetDlgItemInt(hdlg, IDE_ANIM_DELAY, DelayPrayer, FALSE);

		   if (AnimLoaded == FALSE) {
            FILE *fs;
            int z;

			   AnimLoaded = TRUE;
			   strcpy(strVarious, workdir); strcat(strVarious, "\\panim.dat");
			   if ((fs = fopen(strVarious, "r")) != NULL) {
		   		for (z = 0; z < NUM_PRAY_PICTURES; z++) {
		   			fread(&xPray[z], sizeof(INT), 1, fs);
		      		fread(&yPray[z], sizeof(INT), 1, fs);
			      	if ((xPray[z] != 120) || (yPray[z] != 120)) {
		         		MessageBox(hwndMain, "Error while loading praying animations", NULL, MB_ICONSTOP | MB_OK);
         			}
			      	xBitPray[z] = WIDTHBYTES(xPray[z]*8);
						lpvPray[z] = VirtualAlloc(NULL, xBitPray[z]*yPray[z], MEM_COMMIT, PAGE_READWRITE);
      				fread(lpvPray[z], sizeof(BYTE), xBitPray[z]*yPray[z], fs);
		      	}
      			fclose(fs);
		   	}
			}
         CreateCurBitmap();
	      if ((hSrc = FindResource(hInst, "RCDATA_ISLAM", RT_RCDATA)) != NULL)
	   	   if ((hgSrc = LoadResource(NULL, hSrc)) != NULL)
   		   	if ((dataSrc = LockResource(hgSrc)) != NULL)
	      			SetDlgItemText(hdlg, IDE_ANIM_TEXT, (LPTSTR)dataSrc);

         }
			return TRUE;

      case WM_TIMER:
		   if (wparam == ID_TIMER_PRAYING) DisplayAnimations(hdlg, NULL, TRUE);
      	break;

      case WM_DRAWITEM: {
		   DRAWITEMSTRUCT *lpdis = (LPDRAWITEMSTRUCT) lparam;
   		DisplayAnimations(hdlg, lpdis->hDC, FALSE);
         }
      	break;

      case WM_CLOSE:
      	PostMessage(hdlg, WM_COMMAND, IDCANCEL, 0L);
         break;
      case WM_COMMAND:
      	switch ((wCommandAnim = GET_WM_COMMAND_ID(wparam, lparam))) {
		      case IDB_ANIM_RESTART: case IDB_ANIM_PAUSE: case IDB_ANIM_APPLYTIME:
            	if (wCommandAnim == IDB_ANIM_RESTART) { ReStartPraying(hdlg); return 0; }
    				else if (wCommandAnim == IDB_ANIM_PAUSE) {
	               if (!idTimer) idTimer = SetTimer(hdlg, ID_TIMER_PRAYING, DelayPrayer, NULL);
				      else {
	   	   			idTimer = SetTimer(hdlg, ID_TIMER_PRAYING, 200, NULL);
      					KillTimer(hdlg, idTimer);
	         			idTimer = 0;
		   				SendMessage(GetDlgItem(hdlg, IDB_ANIM_PAUSE), WM_SETTEXT, (WPARAM)0, (LPARAM)"Resume");
      				}
    				}
    				else if (wCommandAnim == IDB_ANIM_APPLYTIME) {
		   			DelayPrayer = (int)GetDlgItemInt(hdlg, IDE_ANIM_DELAY, NULL, FALSE);
   					if (DelayPrayer < 10) DelayPrayer = 10;
      				else if (DelayPrayer > 1000) DelayPrayer = 1000;
                  if (idTimer) {
	      				idTimer = SetTimer(hwndMain, ID_TIMER_PRAYING, 2000, NULL);
   	   				KillTimer(hdlg, idTimer);
      					idTimer = SetTimer(hdlg, ID_TIMER_PRAYING, DelayPrayer, NULL);
                  }
	    			}
   	 			if (idTimer) SendMessage(GetDlgItem(hdlg, IDB_ANIM_PAUSE), WM_SETTEXT, (WPARAM)0, (LPARAM)"Pause");
               break;

				case IDC_ANIM_COMBO:
            	if (HIWORD(wparam) ==  CBN_SELENDOK) {
               	if ((CurrentAnim = SendMessage(GetDlgItem(hdlg, IDC_ANIM_COMBO), CB_GETCURSEL, 0, 0L)) != CB_ERR) {
							ReStartPraying(hdlg);
                  }
                  else CurrentAnim = 0;
               }
            	break;

         	default:
	            return FALSE;
         }
	      break;

      default:
   	   return FALSE;
   }
   return TRUE;
}
int DisplayAnimations(HWND hdlg, HDC hDC, int anim)
{
   BOOL bHdc = FALSE;
   HDC hMemDC;
   HBITMAP hOldBitmap;
   HPALETTE hOldPal;
   LPBITMAPINFO lpbih;
   int nt, en;

   if (VratiAnim == TRUE) return 0;
    VratiAnim = TRUE;

   if ((!lpvBits) || (!hBitmap) || (!hInfo)) { VratiAnim=FALSE; return 0; }

   if (hDC == NULL) { bHdc=TRUE; hDC = GetDC(GetDlgItem(hdlg, IDP_ANIM1)); }
   if (!hDC) {VratiAnim = FALSE; return 0; }
   lpbih = GlobalLock(hInfo);
   if (!lpbih) { ReleaseDC(hdlg, hDC); VratiAnim = FALSE; return 0; }
   if (anim == TRUE) PictureProcess();
   //FillMemory(lpvBits, EditImageSize, ecColors[0]);
	PicturePray(10, 0, (BYTE)CurrentPicture);
	PicturePray(260, 0, (BYTE)CurrentMuski);
	PicturePray(410, 0, (BYTE)CurrentZenski);

   SetDIBits(hDC, hBitmap, 0, whBitmap.y, lpvBits, (LPBITMAPINFO)lpbih, DIB_RGB_COLORS);
   GlobalUnlock(hInfo);

   if (pCurrentText != CurrentText) {
		for(en=0; en<2; en++) {
		   ZeroMemory(strAnimNotes, sizeof(strAnimNotes));
   	   for(nt=CurrentText; nt < CurrentText+CurrentNumText && nt <= IDS_PTX_PR_INTENSION; nt++) {
			   ZeroMemory(strAnimNotesTemp, sizeof(strAnimNotesTemp));
		   	if (LoadString(hInst, (UINT)(nt+(en*1000)), strAnimNotesTemp, sizeof(strAnimNotesTemp)) > 0) {
               if (strlen(strAnimNotes) + strlen(strAnimNotesTemp) + 1 < 4096) {
	   				strcat(strAnimNotes, strAnimNotesTemp);
			   		strcat(strAnimNotes, "\r\n");
               }
               else break;
		   	}
      	}
	      SetDlgItemText(hdlg, (UINT)(IDE_ANIM_TEXT + en), (LPTSTR)strAnimNotes);
   	   pCurrentText = CurrentText;
      }
   }
   //else if (anim == FALSE) SetDlgItemText(hdlg, IDE_ANIM_TEXT, (LPTSTR)strAnimNotes[0]);

   hMemDC = CreateCompatibleDC(hDC);
   if (hPalette) {
   	hOldPal = SelectPalette(hDC, hPalette, FALSE);
      RealizePalette(hDC);
   }
   hOldBitmap = SelectObject(hMemDC, hBitmap);
   BitBlt(hDC, 0, 0, whBitmap.x, whBitmap.y, hMemDC, 0, 0, SRCCOPY);

	if (hOldPal) SelectObject(hMemDC, hOldPal);
   if (hOldBitmap) SelectObject(hMemDC, hOldBitmap);
   DeleteDC(hMemDC);
   if (bHdc == TRUE) ReleaseDC(GetDlgItem(hdlg, IDP_ANIM1), hDC);
   VratiAnim = FALSE;
   return 1;
}
void PicturePray(int xp, int yp, BYTE pct)
{
   int x, y;
   BYTE *pict=lpvPray[pct], *lpv=lpvBits;

   for(y=0; y<yPray[pct]; y++) {
	   for(x=0; x<xPray[pct]; x++) {
         if ((whBitmap.y-1-y-yp > 0) && (x+xp < whBitmap.x))
      	lpv[((whBitmap.y-1-y-yp)*BitSize)+(x+xp)] = pict[((yPray[pct]-1-y)*xBitPray[pct])+x];
   	}
	}
}
int CreateCurBitmap(void)
{
	HDC hdc;
   LPBITMAPINFOHEADER lpbih;
   LPRGBQUAD lpRGB;

   if (hBitmap) DeleteObject(hBitmap);
   if (hInfo) GlobalFree(hInfo);

   hInfo = GlobalAlloc(GHND, (DWORD)(sizeof(BITMAPINFOHEADER) + 256 * sizeof(RGBQUAD)));
   if (!hInfo) return 0;
	lpbih = (LPBITMAPINFOHEADER)GlobalLock(hInfo);
   if (!lpbih) return 0;
   lpbih->biSize = sizeof(BITMAPINFOHEADER);
   lpbih->biWidth = whBitmap.x;
   lpbih->biHeight = whBitmap.y;
   lpbih->biPlanes = 1;
   lpbih->biBitCount = (WORD)8;
   lpbih->biCompression = BI_RGB;
   lpbih->biSizeImage = WIDTHBYTES((DWORD)lpbih->biWidth * (DWORD)8) * lpbih->biHeight;
   lpbih->biXPelsPerMeter = 0;
   lpbih->biYPelsPerMeter = 0;
   lpbih->biClrUsed = 256;
   lpbih->biClrImportant = 0;

   lpRGB = (LPRGBQUAD)((LPSTR)(lpbih) + lpbih->biSize);
	FillColorTable(lpRGB);

   hdc = GetDC(hwndMain);
   hBitmap = CreateDIBSection(hdc, (LPBITMAPINFO)lpbih, DIB_RGB_COLORS, &lpvBits, 0, 0L);
   ReleaseDC(hwndMain, hdc);
   if (!hBitmap || !lpvBits) {
	   GlobalUnlock(hInfo);
      if (hBitmap) DeleteObject(hBitmap);
      return 0;
   }
   EditImageSize = lpbih->biSizeImage;
   BitSize = lpbih->biSizeImage/lpbih->biHeight;
   GlobalUnlock(hInfo);
   return 1;
}
int FillColorTable(LPRGBQUAD lpColorTable)
{
   int i;
	WORD *dataPal;
   HRSRC hSrc;
   HGLOBAL hgSrc;
	LPLOGPALETTE lpPal;
   HANDLE hLogPal;

   hSrc = FindResource(hInst, "RCDATA_PALETTE", RT_RCDATA);
   if (hSrc == NULL) return 0;
   hgSrc = LoadResource(NULL, hSrc);
   if (hgSrc == NULL) return 0;
   dataPal = hgSrc;

   hLogPal = GlobalAlloc(GHND, sizeof(LOGPALETTE) + sizeof(PALETTEENTRY) * 256);
   if (!hLogPal) return 0;
   lpPal = (LPLOGPALETTE)GlobalLock(hLogPal);
   lpPal->palVersion = 0x300;
   lpPal->palNumEntries = 256;

   for (i = 0; i < 256; i++, lpColorTable++) {
   	lpColorTable->rgbRed = lpPal->palPalEntry[i].peRed = dataPal[(i*3)];
   	lpColorTable->rgbGreen = lpPal->palPalEntry[i].peGreen = dataPal[(i*3)+1];
   	lpColorTable->rgbBlue = lpPal->palPalEntry[i].peBlue = dataPal[(i*3)+2];
      lpPal->palPalEntry[i].peFlags = PC_NOCOLLAPSE;
   }
   hPalette = CreatePalette(lpPal);
   GlobalUnlock(hLogPal);
   GlobalFree(hLogPal);
   return 1;
}
/*
#define IDS_PTX_AZIM                       1000
#define IDS_PTX_RUKA1                      1001
#define IDS_PTX_RUKA2                      1002
#define IDS_PTX_RUKA3                      1003
#define IDS_PTX_POZDRAV                    1004
#define IDS_PTX_ALLAH_U_AKBAR              1005
#define IDS_PTX_SUBHANE                    1006
#define IDS_PTX_EUZUBIALLAH                1007
#define IDS_PTX_ELHAMDULIALLAH             1008
#define IDS_PTX_SURANOTE                   1009
#define IDS_PTX_ATTAHIYAT                  1017
#define IDS_PTX_SALAT_AL_ANNABI            1018
#define IDS_PTX_SHORT_PRAYER               1019
#define IDS_PTX_CALL_TO_PRAYER             1020
#define IDS_PTX_IQAMAH                     1021
#define IDS_PTX_PR_INTENSION               1022
#define IDS_PTX_END_TEKBIR                 1023
*/
void PictureProcess(void)
{
//UEKBER
	if (CurrentPraying == 0) {
      if (CurrentDelay > 0) {
      	CurrentDelay--;
         if ((CurrentRekat != 1) || (CurrentAnim != 12)) {
   	      if ((CurrentAnim == 0) || (CurrentAnim == 2) || (CurrentAnim == 5) || (CurrentAnim == 7) || (CurrentAnim == 9)) {
         		CurrentText=IDS_PTX_CALL_TO_PRAYER;
   		      CurrentNumText=3;
					//IDS_PTX_CALL_TO_PRAYER             1020
					//IDS_PTX_IQAMAH                     1021
					//IDS_PTX_PR_INTENSION               1022
            }
            else {
         		CurrentText=IDS_PTX_PR_INTENSION;
   		      CurrentNumText=1;
            }
         }
         else {
         	CurrentText=IDS_PTX_IQAMAH;
            CurrentNumText=3;
         }
      }
   	else if ((CurrentPicture == 100) || (CurrentPicture < 18) || (CurrentPicture > 24))
      	CurrentPicture = 18;
      else if (CurrentPicture >= 24) {
      	CurrentDelay = 10;
         CurrentPraying = 1;
         CurrentMuski = 25;
         CurrentZenski=31;
         CurrentText=IDS_PTX_ALLAH_U_AKBAR;
         CurrentNumText=1;
      }
      else CurrentPicture++;
   }
	else if (CurrentPraying == 1) {
      if (CurrentDelay > 0) CurrentDelay--;
   	else if ((CurrentPicture == 100) || (CurrentPicture < 18) || (CurrentPicture > 24))
      	CurrentPicture = 24;
      else if (CurrentPicture <= 18) {
			CurrentDelay = 30;
         CurrentPraying = 6;
         CurrentMuski=26;
         CurrentZenski=32;
         if ((CurrentRekat == 1) && (CurrentAnim == 12)) {
	         CurrentText=IDS_PTX_EUZUBIALLAH;
   	      CurrentNumText=2;
         }
         else {
	         CurrentText=IDS_PTX_SUBHANE;
   	      CurrentNumText=5;
				//IDS_PTX_SUBHANE                    1006
				//IDS_PTX_EUZUBIALLAH                1007
				//IDS_PTX_ELHAMDULIALLAH             1008
         }
      }
      else CurrentPicture--;
   }
//END UEKBER

//CUC
	else if (CurrentPraying == 2) {
      if (CurrentDelay > 0) CurrentDelay--;
   	else if ((CurrentPicture == 100) || (CurrentPicture < 0) || (CurrentPicture > 4))
      	CurrentPicture = 0;
      else if (CurrentPicture >= 4) CurrentPraying = 4;
      else {
         if (CurrentPicture == 0) {
	         CurrentText=IDS_PTX_ALLAH_U_AKBAR;
   	      CurrentNumText=1;
         }
      	CurrentPicture++;
      }
   }
	else if (CurrentPraying == 3) {
      if (CurrentDelay > 0) {
      	CurrentDelay--;
         if (CurrentDelay == 20) CurrentMuski=CurrentZenski=29;
      }
   	else if ((CurrentPicture == 100) || (CurrentPicture < 0) || (CurrentPicture > 4))
      	CurrentPicture = 4;
      else if (CurrentPicture <= 0) {
         if (CurrentRekat-1 > 0) {
         	CurrentDelay = 30;
            CurrentRekat--;
            if ((CurrentRekat == 1) && (CurrentAnim == 12)) CurrentPraying = 0;
            else CurrentPraying = 6;
         }
         else {
         	CurrentDelay = CurrentRekat = 0;
            CurrentPraying = 100;
         }
			CurrentMuski=26;
         CurrentZenski=32;
         if ((CurrentRekat == 2) && ((CurrentAnim == 6) || (CurrentAnim == 10))) {
	         CurrentText=IDS_PTX_SUBHANE;
            CurrentNumText=5;
         }
         else {
	         CurrentText=IDS_PTX_EUZUBIALLAH;
   	      if ((CurrentRekat < 3) && ((CurrentAnim == 0) || (CurrentAnim == 2) || (CurrentAnim == 5) || (CurrentAnim == 7) || (CurrentAnim == 9))) {
               if ((CurrentAnim == 7) && (CurrentRekat == 2)) CurrentNumText = 3;
               else if (CurrentAnim == 0) CurrentNumText = 3;
            	else CurrentNumText = 2;
            }
            else CurrentNumText = 3;

         }
		}
      else {
         if (CurrentPicture >= 3) {
	         CurrentText=IDS_PTX_RUKA3;
   	      CurrentNumText=1;
         }
      	CurrentPicture--;
      }
   }
//END CUC

//SALAT
	else if (CurrentPraying == 4) {
      if (CurrentDelay > 0) CurrentDelay--;
   	else if ((CurrentPicture == 100) || (CurrentPicture < 10) || (CurrentPicture > 17)) {
      	if (CurrentSalat == 0) CurrentPicture = 11;
         else CurrentPicture = 10;
         CurrentText=IDS_PTX_ALLAH_U_AKBAR;
         CurrentNumText=1;
      }
      else if (CurrentPicture >= 17) {
      	CurrentDelay = 10;
         CurrentPraying = 5;
         CurrentMuski=28;
         CurrentZenski=28;
         CurrentText=IDS_PTX_SALAT;
         CurrentNumText=1;
      }
      else CurrentPicture++;
   }
	else if (CurrentPraying == 5) {
      if (CurrentDelay > 0) {
      	CurrentDelay--;
         if (CurrentDelay == 0) {
	         CurrentText=IDS_PTX_ALLAH_U_AKBAR;
   	      CurrentNumText=1;
         }
      }
   	else if ((CurrentPicture == 100) || (CurrentPicture < 10) || (CurrentPicture > 17))
      	CurrentPicture = 17;

      else if (((CurrentRekat == 3) && ((CurrentAnim == 7) || (CurrentAnim == 12))) && (CurrentPicture <= 11) && (CurrentSalat == 1)) {
      	CurrentSalat = 0;
         CurrentPraying = 3;
      }
      else if (((CurrentRekat < 3) && ((CurrentAnim == 7) || (CurrentAnim == 12))) && (CurrentPicture <= 10) && (CurrentSalat == 1)) {
      	CurrentDelay = 30;
         CurrentSalat = 0;
         if (CurrentRekat == 1) CurrentPraying = 8;
         else CurrentPraying = 3;
         CurrentMuski=27;
         CurrentZenski=33;
         CurrentText=IDS_PTX_ATTAHIYAT;
         if (CurrentRekat == 2) CurrentNumText=1;
         else CurrentNumText=2;
      }
      else if (((CurrentRekat == 4) || (CurrentRekat == 2)) && (CurrentAnim != 7) && (CurrentAnim != 12) && (CurrentPicture <= 11) && (CurrentSalat == 1)) {
      	CurrentSalat = 0;
         CurrentPraying = 3;
      }
      else if (((CurrentRekat == 3) || (CurrentRekat == 1)) && (CurrentAnim != 7) && (CurrentAnim != 12) && (CurrentPicture <= 10) && (CurrentSalat == 1)) {
      	CurrentDelay = 30;
         CurrentSalat = 0;
         if (CurrentRekat == 1) CurrentPraying = 8;
         else CurrentPraying = 3;
         CurrentMuski=27;
         CurrentZenski=33;
         CurrentText=IDS_PTX_ATTAHIYAT;
         if ((CurrentRekat == 3) && (CurrentAnim != 6) && (CurrentAnim != 10))
         	CurrentNumText=1;
         else CurrentNumText=2;
      }
      else if (CurrentPicture <= 10) {
      	CurrentDelay = 10;
         CurrentSalat = 1;
         CurrentPraying = 4;
      }
      else CurrentPicture--;
   }
//END SALAT

//RUKA
	else if (CurrentPraying == 6) {
      if (CurrentDelay > 0) CurrentDelay--;
   	else if ((CurrentPicture == 100) || (CurrentPicture < 5) || (CurrentPicture > 9))
      	CurrentPicture = 5;
      else if (CurrentPicture >= 9) {
      	CurrentDelay = 14;
         CurrentPraying = 7;
         CurrentText=IDS_PTX_RUKA2;
         CurrentNumText=1;
      }
      else {
         if (CurrentPicture == 5) {
	         CurrentText=IDS_PTX_RUKA1;
   	      CurrentNumText=1;
         }
      	CurrentPicture++;
      }
   }
	else if (CurrentPraying == 7) {
      if (CurrentDelay > 0) CurrentDelay--;
   	else if ((CurrentPicture == 100) || (CurrentPicture < 5) || (CurrentPicture > 9))
      	CurrentPicture = 9;
      else if (CurrentPicture <= 5) {
      	CurrentDelay = 10;
         CurrentPicture = 0;
         CurrentPraying = 2;
      }
      else {
         if (CurrentPicture <= 6) {
	         CurrentText=IDS_PTX_RUKA3;
   	      CurrentNumText=1;
         }
      	CurrentPicture--;
      }
   }
//ENDING PRAY
	else if (CurrentPraying == 8) {
      if (CurrentDelay > 0) {
      	CurrentDelay--;
         if (CurrentDelay == 20) {
	         CurrentMuski=29;
   	      CurrentZenski=29;
         }
         else if ((CurrentPicture == 37) && (CurrentDelay == 0)) {
         	CurrentPicture = 36;
            CurrentPraying = 9;
         }
      }
   	else if ((CurrentPicture == 100) || (CurrentPicture < 36) || (CurrentPicture > 37))
      	CurrentPicture = 36;
      else if (CurrentPicture == 36) {
      	CurrentPicture = 37;
         CurrentDelay = 14;
         CurrentText=IDS_PTX_POZDRAV;
         CurrentNumText=1;
      }
	}
	else if (CurrentPraying == 9) {
   	if ((CurrentPicture == 100) || (CurrentPicture < 34) || (CurrentPicture > 35))
      	CurrentPicture = 34;
      else if (CurrentPicture == 34) {
      	CurrentPicture = 35;
         CurrentDelay = 14;
         CurrentPraying = 10;
      }
	}
	else if (CurrentPraying == 10) {
      if (CurrentDelay > 0) CurrentDelay--;
   	else if (CurrentPicture == 37) CurrentPicture = 36;
      else {
      	if (CurrentPicture == 36) CurrentPicture = 38;
         else if (CurrentPicture >= 43) {
         	CurrentPraying = 11;
         }
			else {
         	CurrentPicture++;
            if (CurrentPicture == 39) {
		         CurrentMuski=30;
   		      CurrentZenski=30;
		         CurrentText=IDS_PTX_POZDRAV2;
      		   CurrentNumText=2;
            }
         }
      }
	}
	else if (CurrentPraying == 11) {
   	if (CurrentPicture >= 43) CurrentPicture = 40;
   	else if (CurrentPicture == 38) {
         CurrentPicture = 10;
      	CurrentPraying = 100;
      }
      else CurrentPicture--;
	}
//ENDING PRAY
}

//CUC 0-4
//RUKA 5-9
//SALAT 10-17
//UKEBER 18-24

void ReStartPraying(HWND hdlg)
{
	CurrentPicture = 0;
   CurrentDelay = 20;
   CurrentPraying = CurrentSalat = 0;
   CurrentRekat = Rekati[CurrentAnim];
   CurrentMuski = 25;
   CurrentZenski = 31;
	if (idTimer) {
	   idTimer = SetTimer(hdlg, ID_TIMER_PRAYING, DelayPrayer, NULL);
   	KillTimer(hdlg, idTimer);
  	 	idTimer = 0;
	   PictureProcess();
   }
   else PictureProcess();
   idTimer = SetTimer(hdlg, ID_TIMER_PRAYING, DelayPrayer, NULL);
   SendMessage(GetDlgItem(hdlg, IDB_ANIM_PAUSE), WM_SETTEXT, (WPARAM)0, (LPARAM)"Pause");
}


